/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.function.Function;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;

class StaticTableScan
extends BaseTableScan {
    private static final long TARGET_SPLIT_SIZE = 0x2000000L;
    private final Function<StaticTableScan, DataTask> buildTask;

    StaticTableScan(TableOperations ops, Table table, Schema schema, Function<StaticTableScan, DataTask> buildTask) {
        super(ops, table, schema);
        this.buildTask = buildTask;
    }

    private StaticTableScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, Function<StaticTableScan, DataTask> buildTask, ImmutableMap<String, String> options) {
        super(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, options);
        this.buildTask = buildTask;
    }

    @Override
    protected long targetSplitSize(TableOperations ops) {
        return 0x2000000L;
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, ImmutableMap<String, String> options) {
        return new StaticTableScan(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, this.buildTask, options);
    }

    @Override
    protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean caseSensitive, boolean colStats) {
        return CloseableIterable.withNoopClose((Object)((FileScanTask)this.buildTask.apply(this)));
    }
}

