/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroCustomOrderSchemaVisitor;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.BuildAvroProjection;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.PruneColumns;
import org.apache.iceberg.avro.SchemaToType;
import org.apache.iceberg.avro.TypeToSchema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class AvroSchemaUtil {
    public static final String ICEBERG_FIELD_NAME_PROP = "iceberg-field-name";
    public static final String FIELD_ID_PROP = "field-id";
    public static final String KEY_ID_PROP = "key-id";
    public static final String VALUE_ID_PROP = "value-id";
    public static final String ELEMENT_ID_PROP = "element-id";
    public static final String ADJUST_TO_UTC_PROP = "adjust-to-utc";
    private static final org.apache.avro.Schema NULL = org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL);
    private static final Schema.Type MAP = Schema.Type.MAP;
    private static final Schema.Type ARRAY = Schema.Type.ARRAY;
    private static final Schema.Type UNION = Schema.Type.UNION;
    private static final Schema.Type RECORD = Schema.Type.RECORD;

    private AvroSchemaUtil() {
    }

    public static org.apache.avro.Schema convert(Schema schema, String tableName) {
        return AvroSchemaUtil.convert(schema, (Map<Types.StructType, String>)ImmutableMap.of((Object)schema.asStruct(), (Object)tableName));
    }

    public static org.apache.avro.Schema convert(Schema schema, Map<Types.StructType, String> names) {
        return (org.apache.avro.Schema)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeToSchema(names));
    }

    public static org.apache.avro.Schema convert(Type type) {
        return AvroSchemaUtil.convert(type, (Map<Types.StructType, String>)ImmutableMap.of());
    }

    public static org.apache.avro.Schema convert(Types.StructType type, String name) {
        return AvroSchemaUtil.convert((Type)type, (Map<Types.StructType, String>)ImmutableMap.of((Object)type, (Object)name));
    }

    public static org.apache.avro.Schema convert(Type type, Map<Types.StructType, String> names) {
        return (org.apache.avro.Schema)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToSchema(names));
    }

    public static Type convert(org.apache.avro.Schema schema) {
        return AvroSchemaVisitor.visit(schema, new SchemaToType(schema));
    }

    public static Map<Type, org.apache.avro.Schema> convertTypes(Types.StructType type, String name) {
        TypeToSchema converter = new TypeToSchema((Map<Types.StructType, String>)ImmutableMap.of((Object)type, (Object)name));
        TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)converter);
        return ImmutableMap.copyOf(converter.getConversionMap());
    }

    public static org.apache.avro.Schema pruneColumns(org.apache.avro.Schema schema, Set<Integer> selectedIds) {
        return new PruneColumns(selectedIds).rootSchema(schema);
    }

    public static org.apache.avro.Schema buildAvroProjection(org.apache.avro.Schema schema, Schema expected, Map<String, String> renames) {
        return AvroCustomOrderSchemaVisitor.visit(schema, new BuildAvroProjection(expected, renames));
    }

    public static boolean isTimestamptz(org.apache.avro.Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType != null && logicalType instanceof LogicalTypes.TimestampMicros) {
            Object value = schema.getObjectProp(ADJUST_TO_UTC_PROP);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        }
        return false;
    }

    static boolean isOptionSchema(org.apache.avro.Schema schema) {
        if (schema.getType() == UNION && schema.getTypes().size() == 2) {
            if (((org.apache.avro.Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                return true;
            }
            if (((org.apache.avro.Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
                return true;
            }
        }
        return false;
    }

    static org.apache.avro.Schema toOption(org.apache.avro.Schema schema) {
        if (schema.getType() == UNION) {
            Preconditions.checkArgument((boolean)AvroSchemaUtil.isOptionSchema(schema), (String)"Union schemas are not supported: %s", (Object)schema);
            return schema;
        }
        return org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{NULL, schema});
    }

    static org.apache.avro.Schema fromOption(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == UNION ? 1 : 0) != 0, (String)"Expected union schema but was passed: %s", (Object)schema);
        Preconditions.checkArgument((schema.getTypes().size() == 2 ? 1 : 0) != 0, (String)"Expected optional schema, but was passed: %s", (Object)schema);
        if (((org.apache.avro.Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
            return (org.apache.avro.Schema)schema.getTypes().get(1);
        }
        return (org.apache.avro.Schema)schema.getTypes().get(0);
    }

    static org.apache.avro.Schema fromOptions(List<org.apache.avro.Schema> options) {
        Preconditions.checkArgument((options.size() == 2 ? 1 : 0) != 0, (String)"Expected two schemas, but was passed: %s options", (int)options.size());
        if (options.get(0).getType() == Schema.Type.NULL) {
            return options.get(1);
        }
        return options.get(0);
    }

    static boolean isKeyValueSchema(org.apache.avro.Schema schema) {
        return schema.getType() == RECORD && schema.getFields().size() == 2;
    }

    static org.apache.avro.Schema createMap(int keyId, org.apache.avro.Schema keySchema, int valueId, org.apache.avro.Schema valueSchema) {
        String keyValueName = "k" + keyId + "_v" + valueId;
        Schema.Field keyField = new Schema.Field("key", keySchema, null, null);
        keyField.addProp(FIELD_ID_PROP, (Object)keyId);
        Schema.Field valueField = new Schema.Field("value", valueSchema, null, AvroSchemaUtil.isOptionSchema(valueSchema) ? JsonProperties.NULL_VALUE : null);
        valueField.addProp(FIELD_ID_PROP, (Object)valueId);
        return LogicalMap.get().addToSchema(org.apache.avro.Schema.createArray((org.apache.avro.Schema)org.apache.avro.Schema.createRecord((String)keyValueName, null, null, (boolean)false, (List)ImmutableList.of((Object)keyField, (Object)valueField))));
    }

    static org.apache.avro.Schema createProjectionMap(String recordName, int keyId, String keyName, org.apache.avro.Schema keySchema, int valueId, String valueName, org.apache.avro.Schema valueSchema) {
        String keyValueName = "k" + keyId + "_v" + valueId;
        Schema.Field keyField = new Schema.Field("key", keySchema, null, null);
        if (!"key".equals(keyName)) {
            keyField.addAlias(keyName);
        }
        keyField.addProp(FIELD_ID_PROP, (Object)keyId);
        Schema.Field valueField = new Schema.Field("value", valueSchema, null, AvroSchemaUtil.isOptionSchema(valueSchema) ? JsonProperties.NULL_VALUE : null);
        valueField.addProp(FIELD_ID_PROP, (Object)valueId);
        if (!"value".equals(valueName)) {
            valueField.addAlias(valueName);
        }
        org.apache.avro.Schema keyValueRecord = org.apache.avro.Schema.createRecord((String)keyValueName, null, null, (boolean)false, (List)ImmutableList.of((Object)keyField, (Object)valueField));
        if (!keyValueName.equals(recordName)) {
            keyValueRecord.addAlias(recordName);
        }
        return LogicalMap.get().addToSchema(org.apache.avro.Schema.createArray((org.apache.avro.Schema)keyValueRecord));
    }

    private static int getId(org.apache.avro.Schema schema, String propertyName) {
        if (schema.getType() == UNION) {
            return AvroSchemaUtil.getId(AvroSchemaUtil.fromOption(schema), propertyName);
        }
        Object id = schema.getObjectProp(propertyName);
        Preconditions.checkNotNull((Object)id, (String)"Missing expected '%s' property", (Object)propertyName);
        return AvroSchemaUtil.toInt(id);
    }

    public static int getKeyId(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == MAP ? 1 : 0) != 0, (String)"Cannot get map key id for non-map schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, KEY_ID_PROP);
    }

    public static int getValueId(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == MAP ? 1 : 0) != 0, (String)"Cannot get map value id for non-map schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, VALUE_ID_PROP);
    }

    public static int getElementId(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == ARRAY ? 1 : 0) != 0, (String)"Cannot get array element id for non-array schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, ELEMENT_ID_PROP);
    }

    public static int getFieldId(Schema.Field field) {
        Object id = field.getObjectProp(FIELD_ID_PROP);
        Preconditions.checkNotNull((Object)id, (String)"Missing expected '%s' property", (Object)FIELD_ID_PROP);
        return AvroSchemaUtil.toInt(id);
    }

    private static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new UnsupportedOperationException("Cannot coerce value to int: " + value);
    }

    static org.apache.avro.Schema copyRecord(org.apache.avro.Schema record, List<Schema.Field> newFields, String newName) {
        org.apache.avro.Schema copy;
        if (newName != null) {
            copy = org.apache.avro.Schema.createRecord((String)newName, (String)record.getDoc(), null, (boolean)record.isError(), newFields);
            copy.addAlias(record.getName(), record.getNamespace() == null ? "" : record.getNamespace());
        } else {
            copy = org.apache.avro.Schema.createRecord((String)record.getName(), (String)record.getDoc(), (String)record.getNamespace(), (boolean)record.isError(), newFields);
        }
        for (Map.Entry prop : record.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        return copy;
    }

    static Schema.Field copyField(Schema.Field field, org.apache.avro.Schema newSchema, String newName) {
        Schema.Field copy = new Schema.Field(newName, newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry prop : field.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        if (!newName.equals(field.name())) {
            copy.addAlias(field.name());
        }
        return copy;
    }

    static boolean validAvroName(String name) {
        int length = name.length();
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"Empty name");
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char character = name.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') continue;
            return false;
        }
        return true;
    }

    static String sanitize(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(name.length());
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            sb.append(AvroSchemaUtil.sanitize(first));
        } else {
            sb.append(first);
        }
        for (int i = 1; i < length; ++i) {
            char character = name.charAt(i);
            if (!Character.isLetterOrDigit(character) && character != '_') {
                sb.append(AvroSchemaUtil.sanitize(character));
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    private static String sanitize(char character) {
        if (Character.isDigit(character)) {
            return "_" + character;
        }
        return "_x" + Integer.toHexString(character).toUpperCase();
    }
}

