/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import com.google.common.base.Preconditions;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;

public class LogicalMap
extends LogicalType {
    static final String NAME = "map";
    private static final LogicalMap INSTANCE = new LogicalMap();

    static LogicalMap get() {
        return INSTANCE;
    }

    private LogicalMap() {
        super(NAME);
    }

    public void validate(Schema schema) {
        super.validate(schema);
        Preconditions.checkArgument((schema.getType() == Schema.Type.ARRAY ? 1 : 0) != 0, (String)"Invalid type for map, must be an array: %s", (Object)schema);
        Preconditions.checkArgument((boolean)AvroSchemaUtil.isKeyValueSchema(schema.getElementType()), (String)"Invalid key-value record: %s", (Object)schema.getElementType());
    }
}

