/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class TypeToSchema
extends TypeUtil.SchemaVisitor<org.apache.avro.Schema> {
    private static final org.apache.avro.Schema BOOLEAN_SCHEMA = org.apache.avro.Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    private static final org.apache.avro.Schema INTEGER_SCHEMA = org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT);
    private static final org.apache.avro.Schema LONG_SCHEMA = org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG);
    private static final org.apache.avro.Schema FLOAT_SCHEMA = org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT);
    private static final org.apache.avro.Schema DOUBLE_SCHEMA = org.apache.avro.Schema.create((Schema.Type)Schema.Type.DOUBLE);
    private static final org.apache.avro.Schema DATE_SCHEMA = LogicalTypes.date().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
    private static final org.apache.avro.Schema TIME_SCHEMA = LogicalTypes.timeMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG));
    private static final org.apache.avro.Schema TIMESTAMP_SCHEMA = LogicalTypes.timestampMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG));
    private static final org.apache.avro.Schema TIMESTAMPTZ_SCHEMA = LogicalTypes.timestampMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG));
    private static final org.apache.avro.Schema STRING_SCHEMA = org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING);
    private static final org.apache.avro.Schema UUID_SCHEMA = LogicalTypes.uuid().addToSchema(org.apache.avro.Schema.createFixed((String)"uuid_fixed", null, null, (int)16));
    private static final org.apache.avro.Schema BINARY_SCHEMA = org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES);
    private final Map<Type, org.apache.avro.Schema> results = Maps.newHashMap();
    private final Map<Types.StructType, String> names;

    TypeToSchema(Map<Types.StructType, String> names) {
        this.names = names;
    }

    Map<Type, org.apache.avro.Schema> getConversionMap() {
        return this.results;
    }

    public org.apache.avro.Schema schema(Schema schema, org.apache.avro.Schema structSchema) {
        return structSchema;
    }

    public org.apache.avro.Schema struct(Types.StructType struct, List<org.apache.avro.Schema> fieldSchemas) {
        org.apache.avro.Schema recordSchema = this.results.get(struct);
        if (recordSchema != null) {
            return recordSchema;
        }
        String recordName = this.names.get(struct);
        if (recordName == null) {
            recordName = "r" + this.fieldIds().peek();
        }
        List structFields = struct.fields();
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)fieldSchemas.size());
        for (int i = 0; i < structFields.size(); ++i) {
            Types.NestedField structField = (Types.NestedField)structFields.get(i);
            String origFieldName = structField.name();
            boolean isValidFieldName = AvroSchemaUtil.validAvroName(origFieldName);
            String fieldName = isValidFieldName ? origFieldName : AvroSchemaUtil.sanitize(origFieldName);
            Schema.Field field = new Schema.Field(fieldName, fieldSchemas.get(i), null, structField.isOptional() ? JsonProperties.NULL_VALUE : null);
            if (!isValidFieldName) {
                field.addProp("iceberg-field-name", origFieldName);
            }
            field.addProp("field-id", (Object)structField.fieldId());
            fields.add(field);
        }
        recordSchema = org.apache.avro.Schema.createRecord((String)recordName, null, null, (boolean)false, (List)fields);
        this.results.put((Type)struct, recordSchema);
        return recordSchema;
    }

    public org.apache.avro.Schema field(Types.NestedField field, org.apache.avro.Schema fieldSchema) {
        if (field.isOptional()) {
            return AvroSchemaUtil.toOption(fieldSchema);
        }
        return fieldSchema;
    }

    public org.apache.avro.Schema list(Types.ListType list, org.apache.avro.Schema elementSchema) {
        org.apache.avro.Schema listSchema = this.results.get(list);
        if (listSchema != null) {
            return listSchema;
        }
        listSchema = list.isElementOptional() ? org.apache.avro.Schema.createArray((org.apache.avro.Schema)AvroSchemaUtil.toOption(elementSchema)) : org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementSchema);
        listSchema.addProp("element-id", (Object)list.elementId());
        this.results.put((Type)list, listSchema);
        return listSchema;
    }

    public org.apache.avro.Schema map(Types.MapType map, org.apache.avro.Schema keySchema, org.apache.avro.Schema valueSchema) {
        org.apache.avro.Schema mapSchema = this.results.get(map);
        if (mapSchema != null) {
            return mapSchema;
        }
        if (keySchema.getType() == Schema.Type.STRING) {
            mapSchema = org.apache.avro.Schema.createMap((org.apache.avro.Schema)(map.isValueOptional() ? AvroSchemaUtil.toOption(valueSchema) : valueSchema));
            mapSchema.addProp("key-id", (Object)map.keyId());
            mapSchema.addProp("value-id", (Object)map.valueId());
        } else {
            mapSchema = AvroSchemaUtil.createMap(map.keyId(), keySchema, map.valueId(), map.isValueOptional() ? AvroSchemaUtil.toOption(valueSchema) : valueSchema);
        }
        this.results.put((Type)map, mapSchema);
        return mapSchema;
    }

    public org.apache.avro.Schema primitive(Type.PrimitiveType primitive) {
        org.apache.avro.Schema primitiveSchema;
        switch (primitive.typeId()) {
            case BOOLEAN: {
                primitiveSchema = BOOLEAN_SCHEMA;
                break;
            }
            case INTEGER: {
                primitiveSchema = INTEGER_SCHEMA;
                break;
            }
            case LONG: {
                primitiveSchema = LONG_SCHEMA;
                break;
            }
            case FLOAT: {
                primitiveSchema = FLOAT_SCHEMA;
                break;
            }
            case DOUBLE: {
                primitiveSchema = DOUBLE_SCHEMA;
                break;
            }
            case DATE: {
                primitiveSchema = DATE_SCHEMA;
                break;
            }
            case TIME: {
                primitiveSchema = TIME_SCHEMA;
                break;
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)primitive).shouldAdjustToUTC()) {
                    primitiveSchema = TIMESTAMPTZ_SCHEMA;
                    break;
                }
                primitiveSchema = TIMESTAMP_SCHEMA;
                break;
            }
            case STRING: {
                primitiveSchema = STRING_SCHEMA;
                break;
            }
            case UUID: {
                primitiveSchema = UUID_SCHEMA;
                break;
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                primitiveSchema = org.apache.avro.Schema.createFixed((String)("fixed_" + fixed.length()), null, null, (int)fixed.length());
                break;
            }
            case BINARY: {
                primitiveSchema = BINARY_SCHEMA;
                break;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                primitiveSchema = LogicalTypes.decimal((int)decimal.precision(), (int)decimal.scale()).addToSchema(org.apache.avro.Schema.createFixed((String)("decimal_" + decimal.precision() + "_" + decimal.scale()), null, null, (int)TypeUtil.decimalRequriedBytes((int)decimal.precision())));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type ID: " + primitive.typeId());
            }
        }
        this.results.put((Type)primitive, primitiveSchema);
        return primitiveSchema;
    }

    static {
        TIMESTAMP_SCHEMA.addProp("adjust-to-utc", (Object)false);
        TIMESTAMPTZ_SCHEMA.addProp("adjust-to-utc", (Object)true);
    }
}

