/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;

public class HadoopFileIO
implements FileIO {
    private final SerializableConfiguration hadoopConf;

    public HadoopFileIO(Configuration hadoopConf) {
        this.hadoopConf = new SerializableConfiguration(hadoopConf);
    }

    public InputFile newInputFile(String path) {
        return HadoopInputFile.fromLocation(path, this.hadoopConf.get());
    }

    public OutputFile newOutputFile(String path) {
        return HadoopOutputFile.fromPath(new Path(path), this.hadoopConf.get());
    }

    public void deleteFile(String path) {
        Path toDelete = new Path(path);
        FileSystem fs = Util.getFs(toDelete, this.hadoopConf.get());
        try {
            fs.delete(toDelete, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to delete file: %s", new Object[]{path});
        }
    }
}

