/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopTableOperations
implements TableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopTableOperations.class);
    private final Configuration conf;
    private final Path location;
    private TableMetadata currentMetadata = null;
    private Integer version = null;
    private boolean shouldRefresh = true;
    private HadoopFileIO defaultFileIo = null;

    protected HadoopTableOperations(Path location, Configuration conf) {
        this.conf = conf;
        this.location = location;
    }

    @Override
    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    @Override
    public TableMetadata refresh() {
        int ver = this.version != null ? this.version.intValue() : this.readVersionHint();
        try {
            Path metadataFile = this.getMetadataFile(ver);
            if (this.version == null && metadataFile == null && ver == 0) {
                return null;
            }
            if (metadataFile == null) {
                throw new ValidationException("Metadata file for version %d is missing", new Object[]{ver});
            }
            Path nextMetadataFile = this.getMetadataFile(ver + 1);
            while (nextMetadataFile != null) {
                metadataFile = nextMetadataFile;
                nextMetadataFile = this.getMetadataFile(++ver + 1);
            }
            this.version = ver;
            TableMetadata newMetadata = TableMetadataParser.read(this, this.io().newInputFile(metadataFile.toString()));
            String newUUID = newMetadata.uuid();
            if (this.currentMetadata != null) {
                Preconditions.checkState((newUUID == null || newUUID.equals(this.currentMetadata.uuid()) ? 1 : 0) != 0, (String)"Table UUID does not match: current=%s != refreshed=%s", (Object)this.currentMetadata.uuid(), (Object)newUUID);
            }
            this.currentMetadata = newMetadata;
            this.shouldRefresh = false;
            return this.currentMetadata;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to refresh the table", new Object[0]);
        }
    }

    @Override
    public void commit(TableMetadata base, TableMetadata metadata) {
        if (base != this.current()) {
            throw new CommitFailedException("Cannot commit changes based on stale table metadata", new Object[0]);
        }
        if (base == metadata) {
            LOG.info("Nothing to commit.");
            return;
        }
        Preconditions.checkArgument((base == null || base.location().equals(metadata.location()) ? 1 : 0) != 0, (Object)"Hadoop path-based tables cannot be relocated");
        Preconditions.checkArgument((!metadata.properties().containsKey("write.metadata.path") ? 1 : 0) != 0, (Object)"Hadoop path-based tables cannot relocate metadata");
        String codecName = metadata.property("write.metadata.compression-codec", "none");
        TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromName(codecName);
        String fileExtension = TableMetadataParser.getFileExtension(codec);
        Path tempMetadataFile = this.metadataPath(UUID.randomUUID().toString() + fileExtension);
        TableMetadataParser.write(metadata, this.io().newOutputFile(tempMetadataFile.toString()));
        int nextVersion = (this.version != null ? this.version : 0) + 1;
        Path finalMetadataFile = this.metadataFilePath(nextVersion, codec);
        FileSystem fs = this.getFileSystem(tempMetadataFile, this.conf);
        try {
            if (fs.exists(finalMetadataFile)) {
                throw new CommitFailedException("Version %d already exists: %s", new Object[]{nextVersion, finalMetadataFile});
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to check if next version exists: " + finalMetadataFile, new Object[0]);
        }
        this.renameToFinal(fs, tempMetadataFile, finalMetadataFile);
        this.writeVersionHint(nextVersion);
        this.shouldRefresh = true;
    }

    @Override
    public FileIO io() {
        if (this.defaultFileIo == null) {
            this.defaultFileIo = new HadoopFileIO(this.conf);
        }
        return this.defaultFileIo;
    }

    @Override
    public LocationProvider locationProvider() {
        return LocationProviders.locationsFor(this.current().location(), this.current().properties());
    }

    @Override
    public String metadataFileLocation(String fileName) {
        return this.metadataPath(fileName).toString();
    }

    private Path getMetadataFile(int metadataVersion) throws IOException {
        for (TableMetadataParser.Codec codec : TableMetadataParser.Codec.values()) {
            Path metadataFile = this.metadataFilePath(metadataVersion, codec);
            FileSystem fs = this.getFileSystem(metadataFile, this.conf);
            if (fs.exists(metadataFile)) {
                return metadataFile;
            }
            if (!codec.equals((Object)TableMetadataParser.Codec.GZIP) || !(fs = this.getFileSystem(metadataFile = this.oldMetadataFilePath(metadataVersion, codec), this.conf)).exists(metadataFile)) continue;
            return metadataFile;
        }
        return null;
    }

    private Path metadataFilePath(int metadataVersion, TableMetadataParser.Codec codec) {
        return this.metadataPath("v" + metadataVersion + TableMetadataParser.getFileExtension(codec));
    }

    private Path oldMetadataFilePath(int metadataVersion, TableMetadataParser.Codec codec) {
        return this.metadataPath("v" + metadataVersion + TableMetadataParser.getOldFileExtension(codec));
    }

    private Path metadataPath(String filename) {
        return new Path(new Path(this.location, "metadata"), filename);
    }

    private Path versionHintFile() {
        return this.metadataPath("version-hint.text");
    }

    private void writeVersionHint(int versionToWrite) {
        Path versionHintFile = this.versionHintFile();
        FileSystem fs = this.getFileSystem(versionHintFile, this.conf);
        try (FSDataOutputStream out = fs.create(versionHintFile, true);){
            out.write(String.valueOf(versionToWrite).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.warn("Failed to update version hint", (Throwable)e);
        }
    }

    private int readVersionHint() {
        int n;
        Path versionHintFile = this.versionHintFile();
        FileSystem fs = Util.getFs(versionHintFile, this.conf);
        if (!fs.exists(versionHintFile)) {
            return 0;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(versionHintFile)));
        Throwable throwable = null;
        try {
            n = Integer.parseInt(in.readLine().replace("\n", ""));
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    HadoopTableOperations.$closeResource(throwable, in);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{versionHintFile});
            }
        }
        HadoopTableOperations.$closeResource(throwable, in);
        return n;
    }

    private void renameToFinal(FileSystem fs, Path src, Path dst) {
        try {
            if (!fs.rename(src, dst)) {
                CommitFailedException cfe = new CommitFailedException("Failed to commit changes using rename: %s", new Object[]{dst});
                RuntimeException re = this.tryDelete(src);
                if (re != null) {
                    cfe.addSuppressed((Throwable)re);
                }
                throw cfe;
            }
        }
        catch (IOException e) {
            CommitFailedException cfe = new CommitFailedException((Throwable)e, "Failed to commit changes using rename: %s", new Object[]{dst});
            RuntimeException re = this.tryDelete(src);
            if (re != null) {
                cfe.addSuppressed((Throwable)re);
            }
            throw cfe;
        }
    }

    private RuntimeException tryDelete(Path path) {
        try {
            this.io().deleteFile(path.toString());
            return null;
        }
        catch (RuntimeException re) {
            return re;
        }
    }

    protected FileSystem getFileSystem(Path path, Configuration hadoopConf) {
        return Util.getFs(path, hadoopConf);
    }
}

