/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.MappingUtil;

public class NameMapping {
    private static final Joiner DOT = Joiner.on((char)'.');
    private final MappedFields mapping;
    private final Map<Integer, MappedField> fieldsById;
    private final Map<String, MappedField> fieldsByName;

    public static NameMapping of(MappedField ... fields) {
        return new NameMapping(MappedFields.of((List<MappedField>)ImmutableList.copyOf((Object[])fields)));
    }

    public static NameMapping of(List<MappedField> fields) {
        return new NameMapping(MappedFields.of(fields));
    }

    public static NameMapping of(MappedFields fields) {
        return new NameMapping(fields);
    }

    NameMapping(MappedFields mapping) {
        this.mapping = mapping;
        this.fieldsById = MappingUtil.indexById(mapping);
        this.fieldsByName = MappingUtil.indexByName(mapping);
    }

    public MappedField find(int id) {
        return this.fieldsById.get(id);
    }

    public MappedField find(String ... names) {
        return this.fieldsByName.get(DOT.join((Object[])names));
    }

    public MappedField find(List<String> names) {
        return this.fieldsByName.get(DOT.join(names));
    }

    public MappedFields asMappedFields() {
        return this.mapping;
    }

    public String toString() {
        if (this.mapping.fields().isEmpty()) {
            return "[]";
        }
        return "[\n  " + Joiner.on((String)"\n  ").join(this.mapping.fields()) + "\n]";
    }
}

