/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;

public class SnapshotUtil {
    private SnapshotUtil() {
    }

    public static List<Long> currentAncestors(Table table) {
        return SnapshotUtil.ancestorIds(table.currentSnapshot(), arg_0 -> ((Table)table).snapshot(arg_0));
    }

    public static List<Long> ancestorIds(Snapshot snapshot, Function<Long, Snapshot> lookup) {
        ArrayList ancestorIds = Lists.newArrayList();
        Snapshot current = snapshot;
        while (current != null) {
            ancestorIds.add(current.snapshotId());
            if (current.parentId() != null) {
                current = lookup.apply(current.parentId());
                continue;
            }
            current = null;
        }
        return ancestorIds;
    }
}

