/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Objects;
import org.apache.iceberg.StructLike;

public class StructLikeWrapper {
    private StructLike struct;

    public static StructLikeWrapper wrap(StructLike struct) {
        return new StructLikeWrapper(struct);
    }

    private StructLikeWrapper(StructLike struct) {
        this.struct = struct;
    }

    public StructLikeWrapper set(StructLike newStruct) {
        this.struct = newStruct;
        return this;
    }

    public StructLike get() {
        return this.struct;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StructLikeWrapper that = (StructLikeWrapper)other;
        if (this.struct == that.struct) {
            return true;
        }
        if (this.struct == null ^ that.struct == null) {
            return false;
        }
        int len = this.struct.size();
        if (len != that.struct.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Objects.equals(this.struct.get(i, Object.class), that.struct.get(i, Object.class))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 97;
        int len = this.struct.size();
        result = 41 * result + len;
        for (int i = 0; i < len; ++i) {
            result = 41 * result + Objects.hashCode(this.struct.get(i, Object.class));
        }
        return result;
    }
}

