/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.plugin.hive.ConcurrentLazyQueue;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HivePartitionMetadata;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitLoader;
import io.prestosql.plugin.hive.HiveSplitSource;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.InternalHiveSplit;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.s3select.S3SelectPushdown;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.plugin.hive.util.HiveFileIterator;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.plugin.hive.util.InternalHiveSplitFactory;
import io.prestosql.plugin.hive.util.ResumableTask;
import io.prestosql.plugin.hive.util.ResumableTasks;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.TupleDomain;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final Iterable<Pattern> BUCKET_PATTERNS = ImmutableList.of((Object)Pattern.compile("(0\\d+)_\\d+.*"), (Object)Pattern.compile("bucket_(\\d+)"), (Object)Pattern.compile("\\d{8}_\\d{6}_\\d{5}_[a-z0-9]{5}_bucket-(\\d+)(?:[-_.].*)?"));
    private static final ListenableFuture<?> COMPLETED_FUTURE = Futures.immediateFuture(null);
    private final Table table;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final Optional<BucketSplitInfo> tableBucketInfo;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final int loaderConcurrency;
    private final boolean recursiveDirWalkerEnabled;
    private final boolean ignoreAbsentPartitions;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<Iterator<InternalHiveSplit>> fileIterators = new ConcurrentLinkedDeque<Iterator<InternalHiveSplit>>();
    private final Optional<ValidWriteIdList> validWriteIds;
    private final ReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;

    public BackgroundHiveSplitLoader(Table table, Iterable<HivePartitionMetadata> partitions, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, Optional<BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int loaderConcurrency, boolean recursiveDirWalkerEnabled, boolean ignoreAbsentPartitions, Optional<ValidWriteIdList> validWriteIds) {
        this.table = table;
        this.compactEffectivePredicate = compactEffectivePredicate;
        this.tableBucketInfo = tableBucketInfo;
        this.loaderConcurrency = loaderConcurrency;
        this.session = session;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.ignoreAbsentPartitions = ignoreAbsentPartitions;
        this.executor = executor;
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(partitions);
        this.hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        this.validWriteIds = Objects.requireNonNull(validWriteIds, "validWriteIds is null");
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.loaderConcurrency; ++i) {
            ListenableFuture<Void> future = ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
            MoreFutures.addExceptionCallback(future, this.hiveSplitSource::fail);
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeNoMoreSplitsIfNecessary() {
        this.taskExecutionLock.readLock().lock();
        try {
            if (!this.partitions.isEmpty() || !this.fileIterators.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
            return;
        }
        finally {
            this.taskExecutionLock.readLock().unlock();
        }
        this.taskExecutionLock.writeLock().lock();
        try {
            if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                this.hiveSplitSource.noMoreSplits();
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
        }
        finally {
            this.taskExecutionLock.writeLock().unlock();
        }
    }

    private ListenableFuture<?> loadSplits() throws IOException {
        Iterator<InternalHiveSplit> splits = this.fileIterators.poll();
        if (splits == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            return this.loadPartition(partition);
        }
        while (splits.hasNext() && !this.stopped) {
            ListenableFuture<?> future = this.hiveSplitSource.addToQueue(splits.next());
            if (future.isDone()) continue;
            this.fileIterators.addFirst(splits);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> loadPartition(HivePartitionMetadata partition) throws IOException {
        boolean splittable;
        Optional<DeleteDeltaLocations> deleteDeltaLocations;
        Object readPaths;
        String partitionName = partition.getHivePartition().getPartitionId();
        Properties schema = BackgroundHiveSplitLoader.getPartitionSchema(this.table, partition.getPartition());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        TupleDomain effectivePredicate = this.compactEffectivePredicate.transform(HiveColumnHandle.class::cast);
        Path path = new Path(MetastoreUtil.getPartitionLocation(this.table, partition.getPartition()));
        Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, false);
        FileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        boolean s3SelectPushdownEnabled = S3SelectPushdown.shouldEnablePushdownForTable(this.session, this.table, path.toString(), partition.getPartition());
        if (inputFormat instanceof SymlinkTextInputFormat) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
            }
            ListenableFuture<?> lastResult = COMPLETED_FUTURE;
            List targetPaths = this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity().getUser(), () -> BackgroundHiveSplitLoader.getTargetPathsFromSymlink(fs, path));
            for (Path targetPath : targetPaths) {
                TextInputFormat targetInputFormat = new TextInputFormat();
                FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, targetPath);
                JobConf targetJob = ConfigurationUtils.toJobConf(targetFilesystem.getConf());
                targetJob.setInputFormat(TextInputFormat.class);
                Optional principal = this.hdfsContext.getIdentity().getPrincipal();
                if (principal.isPresent()) {
                    targetJob.set("mapreduce.framework.name", "classic");
                    targetJob.set("mapreduce.jobtracker.kerberos.principal", ((Principal)principal.get()).getName());
                }
                targetInputFormat.configure(targetJob);
                FileInputFormat.setInputPaths((JobConf)targetJob, (Path[])new Path[]{targetPath});
                InputSplit[] targetSplits = this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity().getUser(), () -> targetInputFormat.getSplits(targetJob, 0));
                InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(targetFilesystem, partitionName, inputFormat, schema, partitionKeys, (TupleDomain<HiveColumnHandle>)effectivePredicate, partition.getTableToPartitionMapping(), Optional.empty(), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled);
                lastResult = this.addSplitsToSource(targetSplits, splitFactory);
                if (!this.stopped) continue;
                return COMPLETED_FUTURE;
            }
            return lastResult;
        }
        Optional<HiveSplit.BucketConversion> bucketConversion = Optional.empty();
        boolean bucketConversionRequiresWorkerParticipation = false;
        if (partition.getPartition().isPresent()) {
            Optional<HiveBucketProperty> partitionBucketProperty = partition.getPartition().get().getStorage().getBucketProperty();
            if (this.tableBucketInfo.isPresent() && partitionBucketProperty.isPresent()) {
                int readBucketCount = this.tableBucketInfo.get().getReadBucketCount();
                HiveBucketing.BucketingVersion bucketingVersion = partitionBucketProperty.get().getBucketingVersion();
                int partitionBucketCount = partitionBucketProperty.get().getBucketCount();
                if (readBucketCount != partitionBucketCount) {
                    bucketConversion = Optional.of(new HiveSplit.BucketConversion(bucketingVersion, readBucketCount, partitionBucketCount, this.tableBucketInfo.get().getBucketColumns()));
                    if (readBucketCount > partitionBucketCount) {
                        bucketConversionRequiresWorkerParticipation = true;
                    }
                }
            }
        }
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(fs, partitionName, inputFormat, schema, partitionKeys, (TupleDomain<HiveColumnHandle>)effectivePredicate, partition.getTableToPartitionMapping(), bucketConversionRequiresWorkerParticipation ? bucketConversion : Optional.empty(), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled);
        if (BackgroundHiveSplitLoader.shouldUseFileSplitsFromInputFormat(inputFormat)) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Presto cannot read bucketed partition in an input format with UseFileSplitsFromInputFormat annotation: " + inputFormat.getClass().getSimpleName());
            }
            if (AcidUtils.isTransactionalTable(this.table.getParameters())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive transactional tables in an input format with UseFileSplitsFromInputFormat annotation are not supported: " + inputFormat.getClass().getSimpleName());
            }
            JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
            InputSplit[] splits = inputFormat.getSplits(jobConf, 0);
            return this.addSplitsToSource(splits, splitFactory);
        }
        if (AcidUtils.isTransactionalTable(this.table.getParameters())) {
            AcidUtils.Directory directory = this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity().getUser(), () -> AcidUtils.getAcidState((Path)path, (Configuration)configuration, (ValidWriteIdList)this.validWriteIds.orElseThrow(() -> new IllegalStateException("No validWriteIds present")), (boolean)false, (boolean)true));
            if (AcidUtils.isFullAcidTable(this.table.getParameters())) {
                Object baseOrDeltaPath;
                Object object = directory.getBaseDirectory() != null ? directory.getBaseDirectory() : (baseOrDeltaPath = directory.getCurrentDirectories().size() > 0 ? ((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(0)).getPath() : null);
                if (baseOrDeltaPath != null && AcidUtils.OrcAcidVersion.getAcidVersionFromMetaFile((Path)baseOrDeltaPath, (FileSystem)fs) < 2) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive transactional tables are supported with Hive 3.0 and only after a major compaction has been run");
                }
            }
            readPaths = new ArrayList();
            if (!directory.getOriginalFiles().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Original non-ACID files in transactional tables are not supported");
            }
            if (directory.getBaseDirectory() != null) {
                readPaths.add(directory.getBaseDirectory());
            }
            for (Object delta : directory.getCurrentDirectories()) {
                if (delta.isDeleteDelta()) continue;
                readPaths.add(delta.getPath());
            }
            DeleteDeltaLocations.Builder deleteDeltaLocationsBuilder = DeleteDeltaLocations.builder(path);
            for (AcidUtils.ParsedDelta delta : directory.getCurrentDirectories()) {
                if (!delta.isDeleteDelta()) continue;
                deleteDeltaLocationsBuilder.addDeleteDelta(delta.getPath(), delta.getMinWriteId(), delta.getMaxWriteId(), delta.getStatementId());
            }
            deleteDeltaLocations = deleteDeltaLocationsBuilder.build();
        } else {
            readPaths = ImmutableList.of((Object)path);
            deleteDeltaLocations = Optional.empty();
        }
        boolean bl = splittable = HiveUtil.getHeaderCount(schema) == 0 && HiveUtil.getFooterCount(schema) == 0 && !s3SelectPushdownEnabled;
        if (this.tableBucketInfo.isPresent()) {
            Object delta;
            ListenableFuture<?> lastResult = Futures.immediateFuture(null);
            delta = readPaths.iterator();
            while (delta.hasNext()) {
                Path readPath = (Path)delta.next();
                lastResult = this.hiveSplitSource.addToQueue(this.getBucketedSplits(readPath, fs, splitFactory, this.tableBucketInfo.get(), bucketConversion, splittable, deleteDeltaLocations));
            }
            return lastResult;
        }
        Iterator iterator = readPaths.iterator();
        while (iterator.hasNext()) {
            Path readPath = (Path)iterator.next();
            this.fileIterators.addLast(this.createInternalHiveSplitIterator(readPath, fs, splitFactory, splittable, deleteDeltaLocations));
        }
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> addSplitsToSource(InputSplit[] targetSplits, InternalHiveSplitFactory splitFactory) throws IOException {
        ListenableFuture<?> lastResult = COMPLETED_FUTURE;
        for (InputSplit inputSplit : targetSplits) {
            Optional<InternalHiveSplit> internalHiveSplit = splitFactory.createInternalHiveSplit((FileSplit)inputSplit);
            if (internalHiveSplit.isPresent()) {
                lastResult = this.hiveSplitSource.addToQueue(internalHiveSplit.get());
            }
            if (!this.stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private static boolean shouldUseFileSplitsFromInputFormat(InputFormat<?, ?> inputFormat) {
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseFileSplitsFromInputFormat"));
    }

    private Iterator<InternalHiveSplit> createInternalHiveSplitIterator(Path path, FileSystem fileSystem, InternalHiveSplitFactory splitFactory, boolean splittable, Optional<DeleteDeltaLocations> deleteDeltaLocations) {
        return Streams.stream((Iterator)((Object)new HiveFileIterator(this.table, path, fileSystem, this.directoryLister, this.namenodeStats, this.recursiveDirWalkerEnabled ? HiveFileIterator.NestedDirectoryPolicy.RECURSE : HiveFileIterator.NestedDirectoryPolicy.IGNORED, this.ignoreAbsentPartitions))).map(status -> splitFactory.createInternalHiveSplit((LocatedFileStatus)status, OptionalInt.empty(), splittable, deleteDeltaLocations)).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    /*
     * WARNING - void declaration
     */
    private List<InternalHiveSplit> getBucketedSplits(Path path, FileSystem fileSystem, InternalHiveSplitFactory splitFactory, BucketSplitInfo bucketSplitInfo, Optional<HiveSplit.BucketConversion> bucketConversion, boolean splittable, Optional<DeleteDeltaLocations> deleteDeltaLocations) {
        void var15_18;
        int readBucketCount = bucketSplitInfo.getReadBucketCount();
        int tableBucketCount = bucketSplitInfo.getTableBucketCount();
        int partitionBucketCount = bucketConversion.map(HiveSplit.BucketConversion::getPartitionBucketCount).orElse(tableBucketCount);
        int bucketCount = Math.max(readBucketCount, partitionBucketCount);
        ArrayList files = new ArrayList(partitionBucketCount);
        try {
            Iterators.addAll(files, (Iterator)((Object)new HiveFileIterator(this.table, path, fileSystem, this.directoryLister, this.namenodeStats, HiveFileIterator.NestedDirectoryPolicy.FAIL, this.ignoreAbsentPartitions)));
        }
        catch (HiveFileIterator.NestedDirectoryNotAllowedException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. Found sub-directory in bucket directory for partition: %s", this.table.getSchemaTableName(), splitFactory.getPartitionName()));
        }
        ArrayListMultimap bucketFiles = ArrayListMultimap.create();
        for (LocatedFileStatus locatedFileStatus : files) {
            String fileName = locatedFileStatus.getPath().getName();
            OptionalInt bucket = BackgroundHiveSplitLoader.getBucketNumber(fileName);
            if (bucket.isPresent()) {
                bucketFiles.put((Object)bucket.getAsInt(), (Object)locatedFileStatus);
                continue;
            }
            if (files.size() != partitionBucketCount) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. File '%s' does not match the standard naming pattern, and the number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", this.table.getSchemaTableName(), fileName, files.size(), partitionBucketCount, splitFactory.getPartitionName()));
            }
            files.sort(null);
            bucketFiles.clear();
            for (int i = 0; i < files.size(); ++i) {
                bucketFiles.put((Object)i, files.get(i));
            }
        }
        ArrayList<InternalHiveSplit> splitList = new ArrayList<InternalHiveSplit>();
        boolean bl = false;
        while (var15_18 < bucketCount) {
            void partitionBucketNumber = var15_18 % partitionBucketCount;
            void readBucketNumber = var15_18 % readBucketCount;
            boolean containsEligibleTableBucket = false;
            boolean containsIneligibleTableBucket = false;
            for (void tableBucketNumber = var15_18 % tableBucketCount; tableBucketNumber < tableBucketCount; tableBucketNumber += bucketCount) {
                if (bucketSplitInfo.isTableBucketEnabled((int)tableBucketNumber)) {
                    containsEligibleTableBucket = true;
                    continue;
                }
                containsIneligibleTableBucket = true;
            }
            if (containsEligibleTableBucket && containsIneligibleTableBucket) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The bucket filter cannot be satisfied. There are restrictions on the bucket filter when all the following is true: 1. a table has a different buckets count as at least one of its partitions that is read in this query; 2. the table has a different but compatible bucket number with another table in the query; 3. some buckets of the table is filtered out from the query, most likely using a filter on \"$bucket\". (table name: " + this.table.getTableName() + ", table bucket count: " + tableBucketCount + ", partition bucket count: " + partitionBucketCount + ", effective reading bucket count: " + readBucketCount + ")");
            }
            if (containsEligibleTableBucket) {
                for (LocatedFileStatus file : bucketFiles.get((Object)((int)partitionBucketNumber))) {
                    splitFactory.createInternalHiveSplit(file, OptionalInt.of((int)readBucketNumber), splittable, deleteDeltaLocations).ifPresent(splitList::add);
                }
            }
            ++var15_18;
        }
        return splitList;
    }

    @VisibleForTesting
    static OptionalInt getBucketNumber(String name) {
        for (Pattern pattern : BUCKET_PATTERNS) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            return OptionalInt.of(Integer.parseInt(matcher.group(1)));
        }
        return OptionalInt.empty();
    }

    private static List<Path> getTargetPathsFromSymlink(FileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines((Readable)reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List<Column> keys = table.getPartitionColumns();
        List<String> values = partition.get().getValues();
        HiveUtil.checkCondition(keys.size() == values.size(), HiveErrorCode.HIVE_INVALID_METADATA, "Expected %s partition key values, but got %s", keys.size(), values.size());
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            HiveType hiveType = keys.get(i).getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = values.get(i);
            HiveUtil.checkCondition(value != null, HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "partition key value cannot be null for field: %s", name);
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return MetastoreUtil.getHiveSchema(table);
        }
        return MetastoreUtil.getHiveSchema(partition.get(), table);
    }

    public static class BucketSplitInfo {
        private final List<HiveColumnHandle> bucketColumns;
        private final int tableBucketCount;
        private final int readBucketCount;
        private final IntPredicate bucketFilter;

        public static Optional<BucketSplitInfo> createBucketSplitInfo(Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
            int readBucketCount;
            Objects.requireNonNull(bucketHandle, "bucketHandle is null");
            Objects.requireNonNull(bucketFilter, "buckets is null");
            if (!bucketHandle.isPresent()) {
                Preconditions.checkArgument((!bucketFilter.isPresent() ? 1 : 0) != 0, (Object)"bucketHandle must be present if bucketFilter is present");
                return Optional.empty();
            }
            int tableBucketCount = bucketHandle.get().getTableBucketCount();
            if (tableBucketCount != (readBucketCount = bucketHandle.get().getReadBucketCount()) && bucketFilter.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Filter on \"$bucket\" is not supported when the table has partitions with different bucket counts");
            }
            List<HiveColumnHandle> bucketColumns = bucketHandle.get().getColumns();
            IntPredicate predicate = bucketFilter.map(filter -> filter.getBucketsToKeep()::contains).orElse(bucket -> true);
            return Optional.of(new BucketSplitInfo(bucketColumns, tableBucketCount, readBucketCount, predicate));
        }

        private BucketSplitInfo(List<HiveColumnHandle> bucketColumns, int tableBucketCount, int readBucketCount, IntPredicate bucketFilter) {
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
            this.tableBucketCount = tableBucketCount;
            this.readBucketCount = readBucketCount;
            this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        }

        public List<HiveColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getReadBucketCount() {
            return this.readBucketCount;
        }

        public boolean isTableBucketEnabled(int tableBucketNumber) {
            return this.bucketFilter.test(tableBucketNumber);
        }
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResumableTask.TaskStatus process() {
            ListenableFuture future;
            do {
                if (BackgroundHiveSplitLoader.this.stopped) {
                    return ResumableTask.TaskStatus.finished();
                }
                BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                try {
                    future = BackgroundHiveSplitLoader.this.loadSplits();
                }
                catch (Throwable e2) {
                    PrestoException e2;
                    if (e2 instanceof IOException) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, e2);
                    } else if (!(e2 instanceof PrestoException)) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, e2);
                    }
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e2);
                    Preconditions.checkState((boolean)BackgroundHiveSplitLoader.this.stopped);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                finally {
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                }
                BackgroundHiveSplitLoader.this.invokeNoMoreSplitsIfNecessary();
            } while (future.isDone());
            return ResumableTask.TaskStatus.continueOn(future);
        }
    }
}

