/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;
import java.util.Optional;

public class HiveNotReadableException
extends PrestoException {
    private final SchemaTableName tableName;
    private final Optional<String> partition;

    public HiveNotReadableException(SchemaTableName tableName, Optional<String> partition, String message) {
        super((ErrorCodeSupplier)(partition.isPresent() ? HiveErrorCode.HIVE_PARTITION_NOT_READABLE : HiveErrorCode.HIVE_TABLE_READ_ONLY), HiveNotReadableException.composeMessage(tableName, partition, message));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
    }

    private static String composeMessage(SchemaTableName tableName, Optional<String> partition, String message) {
        return partition.isPresent() ? String.format("Table '%s' partition '%s' is not readable: %s", tableName, partition.get(), message) : String.format("Table '%s' is not readable: %s", tableName, message);
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public Optional<String> getPartition() {
        return this.partition;
    }
}

