/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.ReaderProjections;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public interface HivePageSourceFactory {
    public Optional<ReaderPageSourceWithProjections> createPageSource(Configuration var1, ConnectorSession var2, Path var3, long var4, long var6, long var8, Properties var10, List<HiveColumnHandle> var11, TupleDomain<HiveColumnHandle> var12, DateTimeZone var13, Optional<DeleteDeltaLocations> var14);

    public static class ReaderPageSourceWithProjections {
        private final ConnectorPageSource connectorPageSource;
        private final Optional<ReaderProjections> projectedReaderColumns;

        public ReaderPageSourceWithProjections(ConnectorPageSource connectorPageSource, Optional<ReaderProjections> projectedReaderColumns) {
            this.connectorPageSource = Objects.requireNonNull(connectorPageSource, "connectorPageSource is null");
            this.projectedReaderColumns = Objects.requireNonNull(projectedReaderColumns, "projectedReaderColumns is null");
        }

        public ConnectorPageSource getConnectorPageSource() {
            return this.connectorPageSource;
        }

        public Optional<ReaderProjections> getProjectedReaderColumns() {
            return this.projectedReaderColumns;
        }

        public static ReaderPageSourceWithProjections noProjectionAdaptation(ConnectorPageSource connectorPageSource) {
            return new ReaderPageSourceWithProjections(connectorPageSource, Optional.empty());
        }
    }
}

