/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBucketAdapterRecordCursor;
import io.prestosql.plugin.hive.HiveCoercionRecordCursor;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveColumnProjectionInfo;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePageSource;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveReaderProjectionsAdaptingRecordCursor;
import io.prestosql.plugin.hive.HiveRecordCursor;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.ReaderProjections;
import io.prestosql.plugin.hive.ReaderProjectionsAdapter;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.EmptyPageSource;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TypeManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    private final TypeManager typeManager;
    private final DateTimeZone hiveStorageTimeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final Set<HivePageSourceFactory> pageSourceFactories;
    private final Set<HiveRecordCursorProvider> cursorProviders;

    @Inject
    public HivePageSourceProvider(TypeManager typeManager, HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment, Set<HivePageSourceFactory> pageSourceFactories, Set<HiveRecordCursorProvider> cursorProviders, GenericHiveRecordCursorProvider genericCursorProvider) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveConfig, "hiveConfig is null").getDateTimeZone();
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
        this.cursorProviders = ImmutableSet.builder().addAll((Iterable)Objects.requireNonNull(cursorProviders, "cursorProviders is null")).add((Object)genericCursorProvider).build();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        HiveTableHandle hiveTable = (HiveTableHandle)table;
        List<HiveColumnHandle> hiveColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        HiveSplit hiveSplit = (HiveSplit)split;
        Path path = new Path(hiveSplit.getPath());
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, hiveSplit.getDatabase(), hiveSplit.getTable()), path);
        Optional<ConnectorPageSource> pageSource = HivePageSourceProvider.createHivePageSource(this.pageSourceFactories, this.cursorProviders, configuration, session, path, hiveSplit.getBucketNumber(), hiveSplit.getStart(), hiveSplit.getLength(), hiveSplit.getFileSize(), hiveSplit.getFileModifiedTime(), hiveSplit.getSchema(), (TupleDomain<HiveColumnHandle>)hiveTable.getCompactEffectivePredicate().intersect(dynamicFilter.transform(HiveColumnHandle.class::cast).simplify()), hiveColumns, hiveSplit.getPartitionKeys(), this.hiveStorageTimeZone, this.typeManager, hiveSplit.getTableToPartitionMapping(), hiveSplit.getBucketConversion(), hiveSplit.isS3SelectPushdownEnabled(), hiveSplit.getDeleteDeltaLocations());
        if (pageSource.isPresent()) {
            return pageSource.get();
        }
        throw new RuntimeException("Could not find a file reader for split " + hiveSplit);
    }

    public static Optional<ConnectorPageSource> createHivePageSource(Set<HivePageSourceFactory> pageSourceFactories, Set<HiveRecordCursorProvider> cursorProviders, Configuration configuration, ConnectorSession session, Path path, OptionalInt bucketNumber, long start, long length, long fileSize, long fileModifiedTime, Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, TableToPartitionMapping tableToPartitionMapping, Optional<HiveSplit.BucketConversion> bucketConversion, boolean s3SelectPushdownEnabled, Optional<DeleteDeltaLocations> deleteDeltaLocations) {
        if (effectivePredicate.isNone()) {
            return Optional.of(new EmptyPageSource());
        }
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(partitionKeys, columns, bucketConversion.map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of()), tableToPartitionMapping, path, bucketNumber, fileSize, fileModifiedTime);
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        Optional<BucketAdaptation> bucketAdaptation = HivePageSourceProvider.createBucketAdaptation(bucketConversion, bucketNumber, regularAndInterimColumnMappings);
        for (HivePageSourceFactory pageSourceFactory : pageSourceFactories) {
            List<HiveColumnHandle> desiredColumns;
            Optional<HivePageSourceFactory.ReaderPageSourceWithProjections> readerWithProjections = pageSourceFactory.createPageSource(configuration, session, path, start, length, fileSize, schema, desiredColumns = ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, true, typeManager), effectivePredicate, hiveStorageTimeZone, deleteDeltaLocations);
            if (!readerWithProjections.isPresent()) continue;
            ConnectorPageSource pageSource = readerWithProjections.get().getConnectorPageSource();
            Optional<ReaderProjections> readerProjections = readerWithProjections.get().getProjectedReaderColumns();
            Optional<ReaderProjectionsAdapter> adapter = Optional.empty();
            if (readerProjections.isPresent()) {
                adapter = Optional.of(new ReaderProjectionsAdapter(desiredColumns, readerProjections.get()));
            }
            return Optional.of(new HivePageSource(columnMappings, bucketAdaptation, adapter, hiveStorageTimeZone, typeManager, pageSource));
        }
        Iterator<Object> iterator = cursorProviders.iterator();
        while (iterator.hasNext()) {
            HiveRecordCursorProvider provider;
            boolean doCoercion = !((provider = (HiveRecordCursorProvider)iterator.next()) instanceof GenericHiveRecordCursorProvider);
            List<HiveColumnHandle> desiredColumns = ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, doCoercion, typeManager);
            Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> readerWithProjections = provider.createRecordCursor(configuration, session, path, start, length, fileSize, schema, desiredColumns, effectivePredicate, hiveStorageTimeZone, typeManager, s3SelectPushdownEnabled);
            if (!readerWithProjections.isPresent()) continue;
            RecordCursor delegate = readerWithProjections.get().getRecordCursor();
            Optional<ReaderProjections> projections = readerWithProjections.get().getProjectedReaderColumns();
            if (projections.isPresent()) {
                ReaderProjectionsAdapter projectionsAdapter = new ReaderProjectionsAdapter(desiredColumns, projections.get());
                delegate = new HiveReaderProjectionsAdaptingRecordCursor(delegate, projectionsAdapter);
            }
            Preconditions.checkArgument((!deleteDeltaLocations.isPresent() ? 1 : 0) != 0, (Object)"Delete delta is not supported");
            if (bucketAdaptation.isPresent()) {
                delegate = new HiveBucketAdapterRecordCursor(bucketAdaptation.get().getBucketColumnIndices(), bucketAdaptation.get().getBucketColumnHiveTypes(), bucketAdaptation.get().getBucketingVersion(), bucketAdaptation.get().getTableBucketCount(), bucketAdaptation.get().getPartitionBucketCount(), bucketAdaptation.get().getBucketToKeep(), typeManager, delegate);
            }
            if (doCoercion) {
                delegate = new HiveCoercionRecordCursor(regularAndInterimColumnMappings, typeManager, delegate);
            }
            HiveRecordCursor hiveRecordCursor = new HiveRecordCursor(columnMappings, hiveStorageTimeZone, delegate);
            List columnTypes = columns.stream().map(HiveColumnHandle::getType).collect(Collectors.toList());
            return Optional.of(new RecordPageSource(columnTypes, (RecordCursor)hiveRecordCursor));
        }
        return Optional.empty();
    }

    private static Optional<BucketAdaptation> createBucketAdaptation(Optional<HiveSplit.BucketConversion> bucketConversion, OptionalInt bucketNumber, List<ColumnMapping> columnMappings) {
        return bucketConversion.map(conversion -> {
            List baseColumnMapping = columnMappings.stream().filter(mapping -> mapping.getHiveColumnHandle().isBaseColumn()).collect(Collectors.toList());
            ImmutableMap baseHiveColumnToBlockIndex = Maps.uniqueIndex(baseColumnMapping, mapping -> mapping.getHiveColumnHandle().getBaseHiveColumnIndex());
            int[] bucketColumnIndices = conversion.getBucketColumnHandles().stream().mapToInt(arg_0 -> HivePageSourceProvider.lambda$null$2((Map)baseHiveColumnToBlockIndex, arg_0)).toArray();
            List bucketColumnHiveTypes = (List)conversion.getBucketColumnHandles().stream().map(arg_0 -> HivePageSourceProvider.lambda$null$3((Map)baseHiveColumnToBlockIndex, arg_0)).collect(ImmutableList.toImmutableList());
            return new BucketAdaptation(bucketColumnIndices, bucketColumnHiveTypes, conversion.getBucketingVersion(), conversion.getTableBucketCount(), conversion.getPartitionBucketCount(), bucketNumber.getAsInt());
        });
    }

    private static /* synthetic */ HiveType lambda$null$3(Map baseHiveColumnToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)baseHiveColumnToBlockIndex.get(columnHandle.getBaseHiveColumnIndex())).getHiveColumnHandle().getHiveType();
    }

    private static /* synthetic */ int lambda$null$2(Map baseHiveColumnToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)baseHiveColumnToBlockIndex.get(columnHandle.getBaseHiveColumnIndex())).getIndex();
    }

    public static class BucketAdaptation {
        private final int[] bucketColumnIndices;
        private final List<HiveType> bucketColumnHiveTypes;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final int bucketToKeep;

        public BucketAdaptation(int[] bucketColumnIndices, List<HiveType> bucketColumnHiveTypes, HiveBucketing.BucketingVersion bucketingVersion, int tableBucketCount, int partitionBucketCount, int bucketToKeep) {
            this.bucketColumnIndices = bucketColumnIndices;
            this.bucketColumnHiveTypes = bucketColumnHiveTypes;
            this.bucketingVersion = bucketingVersion;
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketToKeep = bucketToKeep;
        }

        public int[] getBucketColumnIndices() {
            return this.bucketColumnIndices;
        }

        public List<HiveType> getBucketColumnHiveTypes() {
            return this.bucketColumnHiveTypes;
        }

        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        public int getBucketToKeep() {
            return this.bucketToKeep;
        }
    }

    public static enum ColumnMappingKind {
        REGULAR,
        PREFILLED,
        INTERIM,
        EMPTY;

    }

    public static class ColumnMapping {
        private final ColumnMappingKind kind;
        private final HiveColumnHandle hiveColumnHandle;
        private final Optional<String> prefilledValue;
        private final OptionalInt index;
        private final Optional<HiveType> baseTypeCoercionFrom;

        public static ColumnMapping regular(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping prefilled(HiveColumnHandle hiveColumnHandle, String prefilledValue, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.PARTITION_KEY || hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)hiveColumnHandle.isBaseColumn(), (Object)"prefilled values not supported for projected columns");
            return new ColumnMapping(ColumnMappingKind.PREFILLED, hiveColumnHandle, Optional.of(prefilledValue), OptionalInt.empty(), baseTypeCoercionFrom);
        }

        public static ColumnMapping interim(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> baseTypeCoercionFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.INTERIM, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), baseTypeCoercionFrom);
        }

        public static ColumnMapping empty(HiveColumnHandle hiveColumnHandle) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.EMPTY, hiveColumnHandle, Optional.empty(), OptionalInt.empty(), Optional.empty());
        }

        private ColumnMapping(ColumnMappingKind kind, HiveColumnHandle hiveColumnHandle, Optional<String> prefilledValue, OptionalInt index, Optional<HiveType> baseTypeCoercionFrom) {
            this.kind = Objects.requireNonNull(kind, "kind is null");
            this.hiveColumnHandle = Objects.requireNonNull(hiveColumnHandle, "hiveColumnHandle is null");
            this.prefilledValue = Objects.requireNonNull(prefilledValue, "prefilledValue is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.baseTypeCoercionFrom = Objects.requireNonNull(baseTypeCoercionFrom, "baseTypeCoercionFrom is null");
        }

        public ColumnMappingKind getKind() {
            return this.kind;
        }

        public String getPrefilledValue() {
            Preconditions.checkState((this.kind == ColumnMappingKind.PREFILLED ? 1 : 0) != 0);
            return this.prefilledValue.get();
        }

        public HiveColumnHandle getHiveColumnHandle() {
            return this.hiveColumnHandle;
        }

        public int getIndex() {
            Preconditions.checkState((this.kind == ColumnMappingKind.REGULAR || this.kind == ColumnMappingKind.INTERIM ? 1 : 0) != 0);
            return this.index.getAsInt();
        }

        public Optional<HiveType> getBaseTypeCoercionFrom() {
            return this.baseTypeCoercionFrom;
        }

        public static List<ColumnMapping> buildColumnMappings(List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, List<HiveColumnHandle> requiredInterimColumns, TableToPartitionMapping tableToPartitionMapping, Path path, OptionalInt bucketNumber, long fileSize, long fileModifiedTime) {
            ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
            HashSet<Integer> baseColumnHiveIndices = new HashSet<Integer>();
            HashMap<Integer, Set> projectionsForColumn = new HashMap<Integer, Set>();
            ImmutableList.Builder columnMappings = ImmutableList.builder();
            int regularIndex = 0;
            for (HiveColumnHandle column : columns) {
                Optional<HiveType> baseTypeCoercionFrom = tableToPartitionMapping.getCoercion(column.getBaseHiveColumnIndex());
                if (column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR) {
                    if (column.isBaseColumn()) {
                        baseColumnHiveIndices.add(column.getBaseHiveColumnIndex());
                    }
                    Preconditions.checkArgument((boolean)projectionsForColumn.computeIfAbsent(column.getBaseHiveColumnIndex(), HashSet::new).add(column.getHiveColumnProjectionInfo()), (Object)"duplicate column in columns list");
                    if (!baseTypeCoercionFrom.isPresent() || ColumnMapping.projectionValidForType(baseTypeCoercionFrom.get(), column.getHiveColumnProjectionInfo())) {
                        columnMappings.add((Object)ColumnMapping.regular(column, regularIndex, baseTypeCoercionFrom));
                        ++regularIndex;
                        continue;
                    }
                    columnMappings.add((Object)ColumnMapping.empty(column));
                    continue;
                }
                columnMappings.add((Object)ColumnMapping.prefilled(column, HiveUtil.getPrefilledColumnValue(column, (HivePartitionKey)partitionKeysByName.get(column.getName()), path, bucketNumber, fileSize, fileModifiedTime), baseTypeCoercionFrom));
            }
            for (HiveColumnHandle column : requiredInterimColumns) {
                Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)"bucketed columns should be base columns");
                if (baseColumnHiveIndices.contains(column.getBaseHiveColumnIndex())) continue;
                if (projectionsForColumn.containsKey(column.getBaseHiveColumnIndex())) {
                    columnMappings.add((Object)ColumnMapping.interim(column, regularIndex, tableToPartitionMapping.getCoercion(column.getBaseHiveColumnIndex())));
                } else {
                    columnMappings.add((Object)ColumnMapping.interim(column, regularIndex, Optional.empty()));
                }
                ++regularIndex;
            }
            return columnMappings.build();
        }

        private static boolean projectionValidForType(HiveType baseType, Optional<HiveColumnProjectionInfo> projection) {
            List dereferences = projection.map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
            Optional<HiveType> targetType = baseType.getHiveTypeForDereferences(dereferences);
            return targetType.isPresent();
        }

        public static List<ColumnMapping> extractRegularAndInterimColumnMappings(List<ColumnMapping> columnMappings) {
            return (List)columnMappings.stream().filter(columnMapping -> columnMapping.getKind() == ColumnMappingKind.REGULAR || columnMapping.getKind() == ColumnMappingKind.INTERIM).collect(ImmutableList.toImmutableList());
        }

        public static List<HiveColumnHandle> toColumnHandles(List<ColumnMapping> regularColumnMappings, boolean doCoercion, TypeManager typeManager) {
            return regularColumnMappings.stream().map(columnMapping -> {
                HiveColumnHandle columnHandle = columnMapping.getHiveColumnHandle();
                if (!doCoercion || !columnMapping.getBaseTypeCoercionFrom().isPresent()) {
                    return columnHandle;
                }
                HiveType fromHiveTypeBase = columnMapping.getBaseTypeCoercionFrom().get();
                Optional<HiveColumnProjectionInfo> newColumnProjectionInfo = columnHandle.getHiveColumnProjectionInfo().map(projectedColumn -> {
                    HiveType fromHiveType = fromHiveTypeBase.getHiveTypeForDereferences(projectedColumn.getDereferenceIndices()).get();
                    return new HiveColumnProjectionInfo(projectedColumn.getDereferenceIndices(), projectedColumn.getDereferenceNames(), fromHiveType, fromHiveType.getType(typeManager));
                });
                return new HiveColumnHandle(columnHandle.getBaseColumnName(), columnHandle.getBaseHiveColumnIndex(), fromHiveTypeBase, fromHiveTypeBase.getType(typeManager), newColumnProjectionInfo, columnHandle.getColumnType(), columnHandle.getComment());
            }).collect(Collectors.toList());
        }
    }
}

