/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.ReaderProjectionsAdapter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class HiveReaderProjectionsAdaptingRecordCursor
implements RecordCursor {
    private final RecordCursor delegate;
    private final ReaderProjectionsAdapter.ChannelMapping[] channelMappings;
    private final Type[] outputTypes;
    private final Type[] inputTypes;
    private final Type[] baseTypes;

    public HiveReaderProjectionsAdaptingRecordCursor(RecordCursor delegate, ReaderProjectionsAdapter projectionsAdapter) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(projectionsAdapter, "projectionsAdapter is null");
        this.channelMappings = new ReaderProjectionsAdapter.ChannelMapping[projectionsAdapter.getOutputToInputMapping().size()];
        projectionsAdapter.getOutputToInputMapping().toArray(this.channelMappings);
        this.outputTypes = new Type[projectionsAdapter.getOutputTypes().size()];
        projectionsAdapter.getOutputTypes().toArray(this.outputTypes);
        this.inputTypes = new Type[projectionsAdapter.getInputTypes().size()];
        projectionsAdapter.getInputTypes().toArray(this.inputTypes);
        this.baseTypes = new Type[this.outputTypes.length];
        for (int i = 0; i < this.baseTypes.length; ++i) {
            Type type = this.inputTypes[this.channelMappings[i].getInputChannelIndex()];
            List<Integer> dereferences = this.channelMappings[i].getDereferenceSequence();
            for (int j = 0; j < dereferences.size(); ++j) {
                type = (Type)type.getTypeParameters().get(dereferences.get(j));
            }
            this.baseTypes[i] = type;
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public Type getType(int field) {
        return this.outputTypes[field];
    }

    public boolean advanceNextPosition() {
        return this.delegate.advanceNextPosition();
    }

    private Block applyDereferences(Block baseObject, List<Integer> dereferences, int length) {
        Preconditions.checkArgument((length <= dereferences.size() ? 1 : 0) != 0);
        Block current = baseObject;
        for (int i = 0; i < length; ++i) {
            current = (Block)current.getObject(dereferences.get(i).intValue(), Block.class);
        }
        return current;
    }

    public boolean getBoolean(int field) {
        int inputFieldIndex = this.channelMappings[field].getInputChannelIndex();
        List<Integer> dereferences = this.channelMappings[field].getDereferenceSequence();
        if (dereferences.isEmpty()) {
            return this.delegate.getBoolean(inputFieldIndex);
        }
        Block elementBlock = (Block)this.delegate.getObject(inputFieldIndex);
        Block baseObject = this.applyDereferences(elementBlock, dereferences, dereferences.size() - 1);
        return this.baseTypes[field].getBoolean(baseObject, ((Integer)Iterables.getLast(dereferences)).intValue());
    }

    public long getLong(int field) {
        int inputFieldIndex = this.channelMappings[field].getInputChannelIndex();
        List<Integer> dereferences = this.channelMappings[field].getDereferenceSequence();
        if (dereferences.isEmpty()) {
            return this.delegate.getLong(inputFieldIndex);
        }
        Block elementBlock = (Block)this.delegate.getObject(inputFieldIndex);
        Block baseObject = this.applyDereferences(elementBlock, dereferences, dereferences.size() - 1);
        return this.baseTypes[field].getLong(baseObject, ((Integer)Iterables.getLast(dereferences)).intValue());
    }

    public double getDouble(int field) {
        int inputFieldIndex = this.channelMappings[field].getInputChannelIndex();
        List<Integer> dereferences = this.channelMappings[field].getDereferenceSequence();
        if (dereferences.isEmpty()) {
            return this.delegate.getDouble(inputFieldIndex);
        }
        Block elementBlock = (Block)this.delegate.getObject(inputFieldIndex);
        Block baseObject = this.applyDereferences(elementBlock, dereferences, dereferences.size() - 1);
        return this.baseTypes[field].getDouble(baseObject, ((Integer)Iterables.getLast(dereferences)).intValue());
    }

    public Slice getSlice(int field) {
        int inputFieldIndex = this.channelMappings[field].getInputChannelIndex();
        List<Integer> dereferences = this.channelMappings[field].getDereferenceSequence();
        if (dereferences.isEmpty()) {
            return this.delegate.getSlice(inputFieldIndex);
        }
        Block elementBlock = (Block)this.delegate.getObject(inputFieldIndex);
        Block baseObject = this.applyDereferences(elementBlock, dereferences, dereferences.size() - 1);
        return this.baseTypes[field].getSlice(baseObject, ((Integer)Iterables.getLast(dereferences)).intValue());
    }

    public Object getObject(int field) {
        int inputFieldIndex = this.channelMappings[field].getInputChannelIndex();
        List<Integer> dereferences = this.channelMappings[field].getDereferenceSequence();
        if (dereferences.isEmpty()) {
            return this.delegate.getObject(inputFieldIndex);
        }
        Block elementBlock = (Block)this.delegate.getObject(inputFieldIndex);
        Block baseObject = this.applyDereferences(elementBlock, dereferences, dereferences.size() - 1);
        return this.baseTypes[field].getObject(baseObject, ((Integer)Iterables.getLast(dereferences)).intValue());
    }

    public boolean isNull(int field) {
        int inputFieldIndex = this.channelMappings[field].getInputChannelIndex();
        List<Integer> dereferences = this.channelMappings[field].getDereferenceSequence();
        if (dereferences.isEmpty()) {
            return this.delegate.isNull(inputFieldIndex);
        }
        if (this.delegate.isNull(inputFieldIndex)) {
            return true;
        }
        Block baseObject = (Block)this.delegate.getObject(inputFieldIndex);
        for (int j = 0; j < dereferences.size() - 1; ++j) {
            int dereferenceIndex = dereferences.get(j);
            if (baseObject.isNull(dereferenceIndex)) {
                return true;
            }
            baseObject = (Block)baseObject.getObject(dereferenceIndex, Block.class);
        }
        int finalDereference = (Integer)Iterables.getLast(dereferences);
        return baseObject.isNull(finalDereference);
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    public void close() {
        this.delegate.close();
    }
}

