/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;

public class HiveSplit
implements ConnectorSplit {
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final long fileModifiedTime;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<HostAddress> addresses;
    private final String database;
    private final String table;
    private final String partitionName;
    private final OptionalInt bucketNumber;
    private final boolean forceLocalScheduling;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final Optional<BucketConversion> bucketConversion;
    private final boolean s3SelectPushdownEnabled;
    private final Optional<DeleteDeltaLocations> deleteDeltaLocations;

    @JsonCreator
    public HiveSplit(@JsonProperty(value="database") String database, @JsonProperty(value="table") String table, @JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="fileModifiedTime") long fileModifiedTime, @JsonProperty(value="schema") Properties schema, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber, @JsonProperty(value="forceLocalScheduling") boolean forceLocalScheduling, @JsonProperty(value="tableToPartitionMapping") TableToPartitionMapping tableToPartitionMapping, @JsonProperty(value="bucketConversion") Optional<BucketConversion> bucketConversion, @JsonProperty(value="s3SelectPushdownEnabled") boolean s3SelectPushdownEnabled, @JsonProperty(value="deleteDeltaLocations") Optional<DeleteDeltaLocations> deleteDeltaLocations) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (Object)"fileSize must be positive");
        Objects.requireNonNull(database, "database is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        Objects.requireNonNull(deleteDeltaLocations, "deleteDeltaLocations is null");
        this.database = database;
        this.table = table;
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.fileModifiedTime = fileModifiedTime;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.addresses = ImmutableList.copyOf(addresses);
        this.bucketNumber = bucketNumber;
        this.forceLocalScheduling = forceLocalScheduling;
        this.tableToPartitionMapping = tableToPartitionMapping;
        this.bucketConversion = bucketConversion;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.deleteDeltaLocations = deleteDeltaLocations;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    @JsonProperty
    public Properties getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @JsonProperty
    public TableToPartitionMapping getTableToPartitionMapping() {
        return this.tableToPartitionMapping;
    }

    @JsonProperty
    public Optional<BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    public boolean isRemotelyAccessible() {
        return !this.forceLocalScheduling;
    }

    @JsonProperty
    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    @JsonProperty
    public Optional<DeleteDeltaLocations> getDeleteDeltaLocations() {
        return this.deleteDeltaLocations;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).put((Object)"fileSize", (Object)this.fileSize).put((Object)"hosts", this.addresses).put((Object)"database", (Object)this.database).put((Object)"table", (Object)this.table).put((Object)"forceLocalScheduling", (Object)this.forceLocalScheduling).put((Object)"partitionName", (Object)this.partitionName).put((Object)"s3SelectPushdownEnabled", (Object)this.s3SelectPushdownEnabled).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).addValue(this.fileSize).toString();
    }

    public static class BucketConversion {
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final List<HiveColumnHandle> bucketColumnNames;

        @JsonCreator
        public BucketConversion(@JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="tableBucketCount") int tableBucketCount, @JsonProperty(value="partitionBucketCount") int partitionBucketCount, @JsonProperty(value="bucketColumnHandles") List<HiveColumnHandle> bucketColumnHandles) {
            this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketColumnNames = Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null");
        }

        @JsonProperty
        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        @JsonProperty
        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        @JsonProperty
        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        @JsonProperty
        public List<HiveColumnHandle> getBucketColumnHandles() {
            return this.bucketColumnNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketConversion that = (BucketConversion)o;
            return this.tableBucketCount == that.tableBucketCount && this.partitionBucketCount == that.partitionBucketCount && Objects.equals(this.bucketColumnNames, that.bucketColumnNames);
        }

        public int hashCode() {
            return Objects.hash(this.tableBucketCount, this.partitionBucketCount, this.bucketColumnNames);
        }
    }
}

