/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.ConditionalModule;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorAccessControl;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeEventListener;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.prestosql.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.hive.HiveAnalyzeProperties;
import io.prestosql.plugin.hive.HiveConnector;
import io.prestosql.plugin.hive.HiveMetadataFactory;
import io.prestosql.plugin.hive.HiveModule;
import io.prestosql.plugin.hive.HiveSchemaProperties;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveTableProperties;
import io.prestosql.plugin.hive.HiveTransactionManager;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.authentication.HiveAuthenticationModule;
import io.prestosql.plugin.hive.azure.HiveAzureModule;
import io.prestosql.plugin.hive.gcs.HiveGcsModule;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastoreModule;
import io.prestosql.plugin.hive.procedure.HiveProcedureModule;
import io.prestosql.plugin.hive.rubix.RubixEnabledConfig;
import io.prestosql.plugin.hive.rubix.RubixInitializer;
import io.prestosql.plugin.hive.rubix.RubixModule;
import io.prestosql.plugin.hive.s3.HiveS3Module;
import io.prestosql.plugin.hive.security.HiveSecurityModule;
import io.prestosql.plugin.hive.security.SystemTableAwareAccessControl;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public final class InternalHiveConnectorFactory {
    private InternalHiveConnectorFactory() {
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Module module) {
        return InternalHiveConnectorFactory.createConnector(catalogName, config, context, module, Optional.empty());
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Module module, Optional<HiveMetastore> metastore) {
        Objects.requireNonNull(config, "config is null");
        ClassLoader classLoader = InternalHiveConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule(catalogName, "io.prestosql.plugin.hive", "presto.plugin.hive"), new JsonModule(), new HiveModule(), new HiveS3Module(), new HiveGcsModule(), new HiveAzureModule(), ConditionalModule.installModuleIf(RubixEnabledConfig.class, RubixEnabledConfig::isCacheEnabled, (Module)new RubixModule()), new HiveMetastoreModule(metastore), new HiveSecurityModule(catalogName), new HiveAuthenticationModule(), new HiveProcedureModule(), new MBeanServerModule(), binder -> {
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
            }, binder -> Multibinder.newSetBinder((Binder)binder, EventListener.class), module});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            if (((RubixEnabledConfig)injector.getInstance(RubixEnabledConfig.class)).isCacheEnabled()) {
                RubixInitializer rubixInitializer = (RubixInitializer)injector.getInstance(RubixInitializer.class);
                rubixInitializer.initializeRubix(context.getNodeManager());
            }
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HiveMetadataFactory metadataFactory = (HiveMetadataFactory)injector.getInstance(HiveMetadataFactory.class);
            HiveTransactionManager transactionManager = (HiveTransactionManager)injector.getInstance(HiveTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            HiveSessionProperties hiveSessionProperties = (HiveSessionProperties)injector.getInstance(HiveSessionProperties.class);
            HiveTableProperties hiveTableProperties = (HiveTableProperties)injector.getInstance(HiveTableProperties.class);
            HiveAnalyzeProperties hiveAnalyzeProperties = (HiveAnalyzeProperties)injector.getInstance(HiveAnalyzeProperties.class);
            ClassLoaderSafeConnectorAccessControl accessControl = new ClassLoaderSafeConnectorAccessControl((ConnectorAccessControl)new SystemTableAwareAccessControl((ConnectorAccessControl)injector.getInstance(ConnectorAccessControl.class)), classLoader);
            Set procedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Procedure>>(){}));
            Set systemTables = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<SystemTable>>(){}));
            Set eventListeners = (Set)((Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<EventListener>>(){}))).stream().map(listener -> new ClassLoaderSafeEventListener(listener, classLoader)).collect(ImmutableSet.toImmutableSet());
            HiveConnector hiveConnector = new HiveConnector(lifeCycleManager, metadataFactory, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), systemTables, procedures, eventListeners, hiveSessionProperties.getSessionProperties(), HiveSchemaProperties.SCHEMA_PROPERTIES, hiveTableProperties.getTableProperties(), hiveAnalyzeProperties.getAnalyzeProperties(), (ConnectorAccessControl)accessControl, classLoader);
            return hiveConnector;
        }
    }
}

