/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import javax.validation.constraints.NotNull;

public class HiveAuthenticationConfig {
    private HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType = HiveMetastoreAuthenticationType.NONE;
    private HdfsAuthenticationType hdfsAuthenticationType = HdfsAuthenticationType.NONE;
    private boolean hdfsImpersonationEnabled;

    @NotNull
    public HiveMetastoreAuthenticationType getHiveMetastoreAuthenticationType() {
        return this.hiveMetastoreAuthenticationType;
    }

    @Config(value="hive.metastore.authentication.type")
    @ConfigDescription(value="Hive Metastore authentication type")
    public HiveAuthenticationConfig setHiveMetastoreAuthenticationType(HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType) {
        this.hiveMetastoreAuthenticationType = hiveMetastoreAuthenticationType;
        return this;
    }

    @NotNull
    public HdfsAuthenticationType getHdfsAuthenticationType() {
        return this.hdfsAuthenticationType;
    }

    @Config(value="hive.hdfs.authentication.type")
    @ConfigDescription(value="HDFS authentication type")
    public HiveAuthenticationConfig setHdfsAuthenticationType(HdfsAuthenticationType hdfsAuthenticationType) {
        this.hdfsAuthenticationType = hdfsAuthenticationType;
        return this;
    }

    public boolean isHdfsImpersonationEnabled() {
        return this.hdfsImpersonationEnabled;
    }

    @Config(value="hive.hdfs.impersonation.enabled")
    @ConfigDescription(value="Should Presto user be impersonated when communicating with HDFS")
    public HiveAuthenticationConfig setHdfsImpersonationEnabled(boolean hdfsImpersonationEnabled) {
        this.hdfsImpersonationEnabled = hdfsImpersonationEnabled;
        return this;
    }

    public static enum HdfsAuthenticationType {
        NONE,
        KERBEROS;

    }

    public static enum HiveMetastoreAuthenticationType {
        NONE,
        KERBEROS;

    }
}

