/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.azure;

import com.google.common.base.Preconditions;
import io.prestosql.plugin.hive.ConfigurationInitializer;
import io.prestosql.plugin.hive.azure.HiveAzureConfig;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;

public class PrestoAzureConfigurationInitializer
implements ConfigurationInitializer {
    private final Optional<String> wasbAccessKey;
    private final Optional<String> wasbStorageAccount;
    private final Optional<String> adlClientId;
    private final Optional<String> adlCredential;
    private final Optional<String> adlRefreshUrl;
    private final Optional<String> abfsAccessKey;
    private final Optional<String> abfsStorageAccount;

    @Inject
    public PrestoAzureConfigurationInitializer(HiveAzureConfig hiveAzureConfig) {
        this.wasbAccessKey = hiveAzureConfig.getWasbAccessKey();
        this.wasbStorageAccount = hiveAzureConfig.getWasbStorageAccount();
        if (this.wasbAccessKey.isPresent() || this.wasbStorageAccount.isPresent()) {
            Preconditions.checkArgument((this.wasbAccessKey.isPresent() && !this.wasbAccessKey.get().isEmpty() ? 1 : 0) != 0, (Object)"hive.azure.wasb-storage-account is set, but hive.azure.wasb-access-key is not");
            Preconditions.checkArgument((this.wasbStorageAccount.isPresent() && !this.wasbStorageAccount.get().isEmpty() ? 1 : 0) != 0, (Object)"hive.azure.wasb-access-key is set, but hive.azure.wasb-storage-account is not");
        }
        this.abfsAccessKey = hiveAzureConfig.getAbfsAccessKey();
        this.abfsStorageAccount = hiveAzureConfig.getAbfsStorageAccount();
        if (this.abfsAccessKey.isPresent() || this.abfsStorageAccount.isPresent()) {
            Preconditions.checkArgument((this.abfsAccessKey.isPresent() && !this.abfsAccessKey.get().isEmpty() ? 1 : 0) != 0, (Object)"hive.azure.abfs-storage-account is set, but hive.azure.abfs-access-key is not");
            Preconditions.checkArgument((this.abfsStorageAccount.isPresent() && !this.abfsStorageAccount.get().isEmpty() ? 1 : 0) != 0, (Object)"hive.azure.abfs-access-key is set, but hive.azure.abfs-storage-account is not");
        }
        this.adlClientId = hiveAzureConfig.getAdlClientId();
        this.adlCredential = hiveAzureConfig.getAdlCredential();
        this.adlRefreshUrl = hiveAzureConfig.getAdlRefreshUrl();
        if (this.adlClientId.isPresent() || this.adlCredential.isPresent() || this.adlRefreshUrl.isPresent()) {
            Preconditions.checkArgument((this.adlClientId.isPresent() && !this.adlClientId.get().isEmpty() && this.adlCredential.isPresent() && !this.adlCredential.get().isEmpty() && this.adlRefreshUrl.isPresent() && !this.adlRefreshUrl.get().isEmpty() ? 1 : 0) != 0, (Object)"If one of adlClientId, adlCredential, adlRefreshUrl is set, all must be set");
        }
    }

    @Override
    public void initializeConfiguration(Configuration config) {
        if (this.wasbAccessKey.isPresent() && this.wasbStorageAccount.isPresent()) {
            config.set(String.format("fs.azure.account.key.%s.blob.core.windows.net", this.wasbStorageAccount.get()), this.wasbAccessKey.get());
        }
        if (this.abfsAccessKey.isPresent() && this.abfsStorageAccount.isPresent()) {
            config.set(String.format("fs.azure.account.key.%s.dfs.core.windows.net", this.abfsStorageAccount.get()), this.abfsAccessKey.get());
            config.set("fs.abfs.impl", AzureBlobFileSystem.class.getName());
        }
        if (this.adlClientId.isPresent() && this.adlCredential.isPresent() && this.adlRefreshUrl.isPresent()) {
            config.set("fs.adl.oauth2.access.token.provider.type", "ClientCredential");
            config.set("fs.adl.oauth2.client.id", this.adlClientId.get());
            config.set("fs.adl.oauth2.credential", this.adlCredential.get());
            config.set("fs.adl.oauth2.refresh.url", this.adlRefreshUrl.get());
            config.set("fs.adl.impl", AdlFileSystem.class.getName());
        }
        config.set("fs.azure.skipUserGroupMetadataDuringInitialization", "true");
    }
}

