/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.coercions;

import io.prestosql.plugin.hive.coercions.TypeCoercer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;

public class VarcharToIntegerNumberCoercer<T extends Type>
extends TypeCoercer<VarcharType, T> {
    private final long minValue;
    private final long maxValue;

    public VarcharToIntegerNumberCoercer(VarcharType fromType, T toType) {
        super(fromType, toType);
        if (toType.equals(TinyintType.TINYINT)) {
            this.minValue = -128L;
            this.maxValue = 127L;
        } else if (toType.equals(SmallintType.SMALLINT)) {
            this.minValue = -32768L;
            this.maxValue = 32767L;
        } else if (toType.equals(IntegerType.INTEGER)) {
            this.minValue = Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
        } else if (toType.equals(BigintType.BIGINT)) {
            this.minValue = Long.MIN_VALUE;
            this.maxValue = Long.MAX_VALUE;
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from from varchar to %s", toType));
        }
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        try {
            long value = Long.parseLong(((VarcharType)this.fromType).getSlice(block, position).toStringUtf8());
            if (this.minValue <= value && value <= this.maxValue) {
                this.toType.writeLong(blockBuilder, value);
            } else {
                blockBuilder.appendNull();
            }
        }
        catch (NumberFormatException e) {
            blockBuilder.appendNull();
        }
    }
}

