/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.PartitionOfflineException;
import io.prestosql.plugin.hive.TableOfflineException;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.PrincipalType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.ProtectMode;

public final class MetastoreUtil {
    private MetastoreUtil() {
    }

    public static Properties getHiveSchema(Table table) {
        return MetastoreUtil.getHiveSchema(table.getStorage(), table.getDataColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    public static Properties getHiveSchema(Partition partition, Table table) {
        return MetastoreUtil.getHiveSchema(partition.getStorage(), partition.getColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    private static Properties getHiveSchema(Storage sd, List<Column> dataColumns, List<Column> tableDataColumns, Map<String, String> parameters, String databaseName, String tableName, List<Column> partitionKeys) {
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", sd.getStorageFormat().getInputFormat());
        schema.setProperty("file.outputformat", sd.getStorageFormat().getOutputFormat());
        schema.setProperty("name", databaseName + "." + tableName);
        schema.setProperty("location", sd.getLocation());
        if (sd.getBucketProperty().isPresent()) {
            schema.setProperty("bucket_field_name", Joiner.on((String)",").join(sd.getBucketProperty().get().getBucketedBy()));
            schema.setProperty("bucket_count", Integer.toString(sd.getBucketProperty().get().getBucketCount()));
        } else {
            schema.setProperty("bucket_count", "0");
        }
        for (Map.Entry<String, String> param : sd.getSerdeParameters().entrySet()) {
            schema.setProperty(param.getKey(), param.getValue() != null ? param.getValue() : "");
        }
        schema.setProperty("serialization.lib", sd.getStorageFormat().getSerDe());
        StringBuilder columnNameBuilder = new StringBuilder();
        StringBuilder columnTypeBuilder = new StringBuilder();
        StringBuilder columnCommentBuilder = new StringBuilder();
        boolean first = true;
        for (Column column : tableDataColumns) {
            if (!first) {
                columnNameBuilder.append(",");
                columnTypeBuilder.append(":");
                columnCommentBuilder.append('\u0000');
            }
            columnNameBuilder.append(column.getName());
            columnTypeBuilder.append(column.getType());
            columnCommentBuilder.append(column.getComment().orElse(""));
            first = false;
        }
        String columnNames = columnNameBuilder.toString();
        String columnTypes = columnTypeBuilder.toString();
        schema.setProperty("columns", columnNames);
        schema.setProperty("columns.types", columnTypes);
        schema.setProperty("columns.comments", columnCommentBuilder.toString());
        schema.setProperty("serialization.ddl", MetastoreUtil.toThriftDdl(tableName, dataColumns));
        StringBuilder partString = new StringBuilder();
        String partStringSep = "";
        StringBuilder partTypesString = new StringBuilder();
        String partTypesStringSep = "";
        for (Column column : partitionKeys) {
            partString.append(partStringSep);
            partString.append(column.getName());
            partTypesString.append(partTypesStringSep);
            partTypesString.append(column.getType().getHiveTypeName().toString());
            if (partStringSep.length() != 0) continue;
            partStringSep = "/";
            partTypesStringSep = ":";
        }
        if (partString.length() > 0) {
            schema.setProperty("partition_columns", partString.toString());
            schema.setProperty("partition_columns.types", partTypesString.toString());
        }
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                schema.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return schema;
    }

    public static ProtectMode getProtectMode(Partition partition) {
        return MetastoreUtil.getProtectMode(partition.getParameters());
    }

    public static ProtectMode getProtectMode(Table table) {
        return MetastoreUtil.getProtectMode(table.getParameters());
    }

    public static boolean isAvroTableWithSchemaSet(Table table) {
        return HiveStorageFormat.AVRO.getSerDe().equals(table.getStorage().getStorageFormat().getSerDeNullable()) && (table.getParameters().get("avro.schema.url") != null || table.getStorage().getSerdeParameters().get("avro.schema.url") != null);
    }

    public static String makePartitionName(Table table, Partition partition) {
        return MetastoreUtil.makePartitionName(table.getPartitionColumns(), partition.getValues());
    }

    public static String makePartitionName(List<Column> partitionColumns, List<String> values) {
        return MetastoreUtil.toPartitionName(partitionColumns.stream().map(Column::getName).collect(Collectors.toList()), values);
    }

    public static String toPartitionName(List<String> names, List<String> values) {
        Preconditions.checkArgument((names.size() == values.size() ? 1 : 0) != 0, (Object)"partition value count must match partition column count");
        Preconditions.checkArgument((boolean)values.stream().allMatch(Objects::nonNull), (Object)"partition value must not be null");
        return FileUtils.makePartName(names, values);
    }

    public static String getPartitionLocation(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return table.getStorage().getLocation();
        }
        return partition.get().getStorage().getLocation();
    }

    private static String toThriftDdl(String structName, List<Column> columns) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(ColumnType.typeToThriftType((String)column.getType().getHiveTypeName().toString()));
            ddl.append(' ');
            ddl.append(column.getName());
        }
        ddl.append("}");
        return ddl.toString();
    }

    private static ProtectMode getProtectMode(Map<String, String> parameters) {
        if (!parameters.containsKey(ProtectMode.PARAMETER_NAME)) {
            return new ProtectMode();
        }
        return ProtectMode.getProtectModeFromString((String)parameters.get(ProtectMode.PARAMETER_NAME));
    }

    public static void verifyOnline(SchemaTableName tableName, Optional<String> partitionName, ProtectMode protectMode, Map<String, String> parameters) {
        if (protectMode.offline) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), false, null);
            }
            throw new TableOfflineException(tableName, false, null);
        }
        String prestoOffline = parameters.get("presto_offline");
        if (!Strings.isNullOrEmpty((String)prestoOffline)) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), true, prestoOffline);
            }
            throw new TableOfflineException(tableName, true, prestoOffline);
        }
    }

    public static void verifyCanDropColumn(HiveMetastore metastore, HiveIdentity identity, String databaseName, String tableName, String columnName) {
        Table table = metastore.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        if (table.getPartitionColumns().stream().anyMatch(column -> column.getName().equals(columnName))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition columns");
        }
        if (table.getDataColumns().size() <= 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the only non-partition column in a table");
        }
    }

    public static PrincipalPrivileges buildInitialPrivilegeSet(String tableOwner) {
        HivePrincipal owner = new HivePrincipal(PrincipalType.USER, tableOwner);
        return new PrincipalPrivileges((Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.builder().put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true, owner, owner)).build(), (Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.of());
    }
}

