/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.cache;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastoreDecorator;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.cache.ForCachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.cache.ReentrantBoundedExecutor;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CachingHiveMetastoreModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CachingHiveMetastoreConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HiveMetastoreDecorator.class);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
    }

    @Provides
    @Singleton
    public HiveMetastore createCachingHiveMetastore(@ForCachingHiveMetastore HiveMetastore delegate, @ForCachingHiveMetastore Executor executor, CachingHiveMetastoreConfig config, Optional<HiveMetastoreDecorator> hiveMetastoreDecorator) {
        HiveMetastore decoratedDelegate = hiveMetastoreDecorator.map(decorator -> decorator.decorate(delegate)).orElse(delegate);
        return CachingHiveMetastore.cachingHiveMetastore(decoratedDelegate, executor, config);
    }

    @Provides
    @Singleton
    @ForCachingHiveMetastore
    public Executor createCachingHiveMetastoreExecutor(CatalogName catalogName, CachingHiveMetastoreConfig hiveConfig) {
        return new ReentrantBoundedExecutor(Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-metastore-" + catalogName + "-%s"))), hiveConfig.getMaxMetastoreRefreshThreads());
    }
}

