/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.cache;

import io.airlift.concurrent.BoundedExecutor;
import java.util.Objects;
import java.util.concurrent.Executor;

public class ReentrantBoundedExecutor
implements Executor {
    private final ThreadLocal<Boolean> executorThreadMarkers = ThreadLocal.withInitial(() -> false);
    private final Executor boundedExecutor;
    private final Executor coreExecutor;

    ReentrantBoundedExecutor(Executor coreExecutor, int maxThreads) {
        this.boundedExecutor = new BoundedExecutor(Objects.requireNonNull(coreExecutor, "coreExecutor is null"), maxThreads);
        this.coreExecutor = coreExecutor;
    }

    @Override
    public void execute(Runnable task) {
        if (this.executorThreadMarkers.get().booleanValue()) {
            this.coreExecutor.execute(task);
            return;
        }
        this.boundedExecutor.execute(() -> {
            this.executorThreadMarkers.set(true);
            try {
                task.run();
            }
            finally {
                this.executorThreadMarkers.remove();
            }
        });
    }
}

