/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class GlueExpressionUtil {
    private static final Joiner JOINER = Joiner.on((String)" AND ");
    private static final Set<String> QUOTED_TYPES = ImmutableSet.of((Object)"string", (Object)"char", (Object)"varchar", (Object)"date", (Object)"timestamp", (Object)"binary", (Object[])new String[]{"varbinary"});

    private GlueExpressionUtil() {
    }

    public static String buildGlueExpression(List<Column> partitionKeys, List<String> partitionValues) {
        if (partitionValues == null || partitionValues.isEmpty()) {
            return null;
        }
        if (partitionKeys == null || partitionValues.size() != partitionKeys.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Incorrect number of partition values: " + partitionValues);
        }
        LinkedList<String> predicates = new LinkedList<String>();
        for (int i = 0; i < partitionValues.size(); ++i) {
            if (Strings.isNullOrEmpty((String)partitionValues.get(i))) continue;
            predicates.add(GlueExpressionUtil.buildPredicate(partitionKeys.get(i), partitionValues.get(i)));
        }
        return JOINER.join(predicates);
    }

    private static String buildPredicate(Column partitionKey, String value) {
        if (GlueExpressionUtil.isQuotedType(partitionKey.getType())) {
            return String.format("(%s='%s')", partitionKey.getName(), value);
        }
        return String.format("(%s=%s)", partitionKey.getName(), value);
    }

    private static boolean isQuotedType(HiveType type) {
        return QUOTED_TYPES.contains(type.getTypeSignature().getBase());
    }
}

