/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.amazonaws.handlers.RequestHandler2;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.ForRecordingHiveMetastore;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.RecordingHiveMetastore;
import io.prestosql.plugin.hive.metastore.WriteHiveMetastoreRecordingProcedure;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastoreModule;
import io.prestosql.plugin.hive.metastore.cache.ForCachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.glue.DisabledGlueColumnStatisticsProvider;
import io.prestosql.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.prestosql.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.prestosql.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.prestosql.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.prestosql.spi.procedure.Procedure;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.weakref.jmx.guice.ExportBinder;

public class GlueMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(GlueHiveMetastoreConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, GlueColumnStatisticsProvider.class).setDefault().to(DisabledGlueColumnStatisticsProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(RequestHandler2.class, ForGlueHiveMetastore.class));
        if (((HiveConfig)this.buildConfigObject(HiveConfig.class)).getRecordingPath() != null) {
            binder.bind(HiveMetastore.class).annotatedWith(ForRecordingHiveMetastore.class).to(GlueHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(GlueHiveMetastore.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(GlueHiveMetastore.class).withGeneratedName();
            binder.bind(HiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(RecordingHiveMetastore.class).withGeneratedName();
            Multibinder procedures = Multibinder.newSetBinder((Binder)binder, Procedure.class);
            procedures.addBinding().toProvider(WriteHiveMetastoreRecordingProcedure.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(HiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(GlueHiveMetastore.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(generator -> generator.generatedNameOf(GlueHiveMetastore.class));
        }
        binder.install((Module)new CachingHiveMetastoreModule());
    }

    @Provides
    @Singleton
    @ForGlueHiveMetastore
    public Executor createExecutor(CatalogName catalogName, GlueHiveMetastoreConfig hiveConfig) {
        if (hiveConfig.getGetPartitionThreads() == 1) {
            return MoreExecutors.directExecutor();
        }
        return new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-glue-%s")), hiveConfig.getGetPartitionThreads());
    }
}

