/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.units.Duration;
import java.time.Clock;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CoalescingCounter {
    private final Clock clock;
    private final long coalescingDurationMillis;
    @GuardedBy(value="this")
    private long count;
    @GuardedBy(value="this")
    private long lastUpdateTime;

    public CoalescingCounter(Duration coalescingDuration) {
        this(Clock.systemUTC(), coalescingDuration);
    }

    @VisibleForTesting
    CoalescingCounter(Clock clock, Duration coalescingDuration) {
        this.clock = Objects.requireNonNull(clock, "clock is null");
        this.coalescingDurationMillis = Objects.requireNonNull(coalescingDuration, "coalescingDuration is null").toMillis();
    }

    public synchronized void increment() {
        long now = this.clock.instant().toEpochMilli();
        if (this.lastUpdateTime + this.coalescingDurationMillis >= now) {
            return;
        }
        ++this.count;
        this.lastUpdateTime = now;
    }

    public synchronized long get() {
        return this.count;
    }

    public synchronized long incrementAndGet() {
        this.increment();
        return this.get();
    }
}

