/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSource;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;

@NotThreadSafe
public class OrcDeletedRows {
    private final String sourceFileName;
    private final OrcDeleteDeltaPageSourceFactory pageSourceFactory;
    private final String sessionUser;
    private final Configuration configuration;
    private final HdfsEnvironment hdfsEnvironment;
    private final DeleteDeltaLocations deleteDeltaLocations;
    @Nullable
    private Set<RowId> deletedRows;

    public OrcDeletedRows(String sourceFileName, OrcDeleteDeltaPageSourceFactory pageSourceFactory, String sessionUser, Configuration configuration, HdfsEnvironment hdfsEnvironment, DeleteDeltaLocations deleteDeltaLocations) {
        this.sourceFileName = Objects.requireNonNull(sourceFileName, "sourceFileName is null");
        this.pageSourceFactory = Objects.requireNonNull(pageSourceFactory, "pageSourceFactory is null");
        this.sessionUser = Objects.requireNonNull(sessionUser, "sessionUser is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.deleteDeltaLocations = Objects.requireNonNull(deleteDeltaLocations, "deleteDeltaLocations is null");
    }

    public MaskDeletedRowsFunction getMaskDeletedRowsFunction(Page sourcePage) {
        return new MaskDeletedRows(sourcePage);
    }

    private Set<RowId> getDeletedRows() {
        if (this.deletedRows != null) {
            return this.deletedRows;
        }
        ImmutableSet.Builder deletedRowsBuilder = ImmutableSet.builder();
        for (DeleteDeltaLocations.DeleteDeltaInfo deleteDeltaInfo : this.deleteDeltaLocations.getDeleteDeltas()) {
            Path path = OrcDeletedRows.createPath(this.deleteDeltaLocations.getPartitionLocation(), deleteDeltaInfo, this.sourceFileName);
            try {
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(this.sessionUser, path, this.configuration);
                FileStatus fileStatus = this.hdfsEnvironment.doAs(this.sessionUser, () -> fileSystem.getFileStatus(path));
                OrcDeleteDeltaPageSource pageSource = this.pageSourceFactory.createPageSource(fileStatus.getPath(), fileStatus.getLen());
                Throwable throwable = null;
                try {
                    while (!pageSource.isFinished()) {
                        Page page = pageSource.getNextPage();
                        if (page == null) continue;
                        for (int i = 0; i < page.getPositionCount(); ++i) {
                            deletedRowsBuilder.add((Object)new RowId(page, i));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pageSource == null) continue;
                    if (throwable != null) {
                        try {
                            pageSource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pageSource.close();
                }
            }
            catch (FileNotFoundException fileSystem) {
            }
            catch (PrestoException e) {
                throw e;
            }
            catch (OrcCorruptionException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Failed to read ORC delete delta file: " + path, (Throwable)e);
            }
            catch (IOException | RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, "Failed to read ORC delete delta file: " + path, (Throwable)e);
            }
        }
        this.deletedRows = deletedRowsBuilder.build();
        return this.deletedRows;
    }

    private static Path createPath(String partitionLocation, DeleteDeltaLocations.DeleteDeltaInfo deleteDeltaInfo, String fileName) {
        Path directory = new Path(partitionLocation, AcidUtils.deleteDeltaSubdir((long)deleteDeltaInfo.getMinWriteId(), (long)deleteDeltaInfo.getMaxWriteId(), (int)deleteDeltaInfo.getStatementId()));
        return new Path(directory, fileName);
    }

    private static class RowId {
        private static final int ORIGINAL_TRANSACTION_INDEX = 0;
        private static final int BUCKET_ID_INDEX = 1;
        private static final int ROW_ID_INDEX = 2;
        private final long originalTransaction;
        private final int bucket;
        private final long rowId;

        private RowId(Page page, int position) {
            this.originalTransaction = BigintType.BIGINT.getLong(page.getBlock(0), position);
            this.bucket = Math.toIntExact(IntegerType.INTEGER.getLong(page.getBlock(1), position));
            this.rowId = BigintType.BIGINT.getLong(page.getBlock(2), position);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowId other = (RowId)o;
            return this.originalTransaction == other.originalTransaction && this.bucket == other.bucket && this.rowId == other.rowId;
        }

        public int hashCode() {
            return Objects.hash(this.originalTransaction, this.bucket, this.rowId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("originalTransaction", this.originalTransaction).add("bucket", this.bucket).add("rowId", this.rowId).toString();
        }
    }

    @NotThreadSafe
    private class MaskDeletedRows
    implements MaskDeletedRowsFunction {
        @Nullable
        private Page sourcePage;
        private int positionCount;
        @Nullable
        private int[] validPositions;

        public MaskDeletedRows(Page sourcePage) {
            this.sourcePage = Objects.requireNonNull(sourcePage, "sourcePage is null");
        }

        @Override
        public int getPositionCount() {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            return this.positionCount;
        }

        @Override
        public Block apply(Block block) {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            if (this.positionCount == block.getPositionCount()) {
                return block;
            }
            return new DictionaryBlock(this.positionCount, block, this.validPositions);
        }

        private void loadValidPositions() {
            Verify.verify((this.sourcePage != null ? 1 : 0) != 0, (String)"sourcePage is null", (Object[])new Object[0]);
            Set deletedRows = OrcDeletedRows.this.getDeletedRows();
            if (deletedRows.isEmpty()) {
                this.positionCount = this.sourcePage.getPositionCount();
                this.sourcePage = null;
                return;
            }
            int[] validPositions = new int[this.sourcePage.getPositionCount()];
            int validPositionsIndex = 0;
            for (int position = 0; position < this.sourcePage.getPositionCount(); ++position) {
                if (deletedRows.contains(new RowId(this.sourcePage, position))) continue;
                validPositions[validPositionsIndex] = position;
                ++validPositionsIndex;
            }
            this.positionCount = validPositionsIndex;
            this.validPositions = validPositions;
            this.sourcePage = null;
        }
    }

    public static interface MaskDeletedRowsFunction {
        public int getPositionCount();

        public Block apply(Block var1);

        public static MaskDeletedRowsFunction noMaskForPage(final Page page) {
            return new MaskDeletedRowsFunction(){
                int positionCount;
                {
                    this.positionCount = page.getPositionCount();
                }

                @Override
                public int getPositionCount() {
                    return this.positionCount;
                }

                @Override
                public Block apply(Block block) {
                    return block;
                }
            };
        }
    }
}

