/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcReaderOptions;
import javax.validation.constraints.NotNull;

public class OrcReaderConfig {
    private boolean useColumnNames;
    private OrcReaderOptions options = new OrcReaderOptions();

    public OrcReaderOptions toOrcReaderOptions() {
        return this.options;
    }

    public boolean isUseColumnNames() {
        return this.useColumnNames;
    }

    @Config(value="hive.orc.use-column-names")
    @ConfigDescription(value="Access ORC columns using names from the file")
    public OrcReaderConfig setUseColumnNames(boolean useColumnNames) {
        this.useColumnNames = useColumnNames;
        return this;
    }

    public boolean isBloomFiltersEnabled() {
        return this.options.isBloomFiltersEnabled();
    }

    @Config(value="hive.orc.bloom-filters.enabled")
    public OrcReaderConfig setBloomFiltersEnabled(boolean bloomFiltersEnabled) {
        this.options = this.options.withBloomFiltersEnabled(bloomFiltersEnabled);
        return this;
    }

    @NotNull
    public DataSize getMaxMergeDistance() {
        return this.options.getMaxMergeDistance();
    }

    @Config(value="hive.orc.max-merge-distance")
    public OrcReaderConfig setMaxMergeDistance(DataSize maxMergeDistance) {
        this.options = this.options.withMaxMergeDistance(maxMergeDistance);
        return this;
    }

    @NotNull
    public DataSize getMaxBufferSize() {
        return this.options.getMaxBufferSize();
    }

    @Config(value="hive.orc.max-buffer-size")
    public OrcReaderConfig setMaxBufferSize(DataSize maxBufferSize) {
        this.options = this.options.withMaxBufferSize(maxBufferSize);
        return this;
    }

    @NotNull
    public DataSize getTinyStripeThreshold() {
        return this.options.getTinyStripeThreshold();
    }

    @Config(value="hive.orc.tiny-stripe-threshold")
    public OrcReaderConfig setTinyStripeThreshold(DataSize tinyStripeThreshold) {
        this.options = this.options.withTinyStripeThreshold(tinyStripeThreshold);
        return this;
    }

    @NotNull
    public DataSize getStreamBufferSize() {
        return this.options.getStreamBufferSize();
    }

    @Config(value="hive.orc.stream-buffer-size")
    public OrcReaderConfig setStreamBufferSize(DataSize streamBufferSize) {
        this.options = this.options.withStreamBufferSize(streamBufferSize);
        return this;
    }

    @NotNull
    public DataSize getMaxBlockSize() {
        return this.options.getMaxBlockSize();
    }

    @Config(value="hive.orc.max-read-block-size")
    public OrcReaderConfig setMaxBlockSize(DataSize maxBlockSize) {
        this.options = this.options.withMaxReadBlockSize(maxBlockSize);
        return this;
    }

    @Deprecated
    public boolean isLazyReadSmallRanges() {
        return this.options.isLazyReadSmallRanges();
    }

    @Deprecated
    @Config(value="hive.orc.lazy-read-small-ranges")
    @ConfigDescription(value="ORC read small disk ranges lazily")
    public OrcReaderConfig setLazyReadSmallRanges(boolean lazyReadSmallRanges) {
        this.options = this.options.withLazyReadSmallRanges(lazyReadSmallRanges);
        return this;
    }

    @Deprecated
    public boolean isNestedLazy() {
        return this.options.isNestedLazy();
    }

    @Deprecated
    @Config(value="hive.orc.nested-lazy")
    @ConfigDescription(value="ORC lazily read nested data")
    public OrcReaderConfig setNestedLazy(boolean nestedLazy) {
        this.options = this.options.withNestedLazy(nestedLazy);
        return this;
    }
}

