/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.prestosql.parquet.ParquetReaderOptions;
import javax.validation.constraints.NotNull;

public class ParquetReaderConfig {
    private ParquetReaderOptions options = new ParquetReaderOptions();

    @Deprecated
    public boolean isFailOnCorruptedStatistics() {
        return this.options.isFailOnCorruptedStatistics();
    }

    @Deprecated
    @Config(value="parquet.fail-on-corrupted-statistics")
    @LegacyConfig(value={"hive.parquet.fail-on-corrupted-statistics"})
    @ConfigDescription(value="Fail when scanning Parquet files with corrupted statistics")
    public ParquetReaderConfig setFailOnCorruptedStatistics(boolean failOnCorruptedStatistics) {
        this.options = this.options.withFailOnCorruptedStatistics(failOnCorruptedStatistics);
        return this;
    }

    @NotNull
    public DataSize getMaxReadBlockSize() {
        return this.options.getMaxReadBlockSize();
    }

    @Config(value="parquet.max-read-block-size")
    @LegacyConfig(value={"hive.parquet.max-read-block-size"})
    public ParquetReaderConfig setMaxReadBlockSize(DataSize maxReadBlockSize) {
        this.options = this.options.withMaxReadBlockSize(maxReadBlockSize);
        return this;
    }

    @NotNull
    public DataSize getMaxMergeDistance() {
        return this.options.getMaxMergeDistance();
    }

    @Config(value="parquet.max-merge-distance")
    public ParquetReaderConfig setMaxMergeDistance(DataSize distance) {
        this.options = this.options.withMaxMergeDistance(distance);
        return this;
    }

    @NotNull
    public DataSize getMaxBufferSize() {
        return this.options.getMaxBufferSize();
    }

    @Config(value="parquet.max-buffer-size")
    public ParquetReaderConfig setMaxBufferSize(DataSize size) {
        this.options = this.options.withMaxBufferSize(size);
        return this;
    }

    public ParquetReaderOptions toParquetReaderOptions() {
        return this.options;
    }
}

