/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rubix;

import io.airlift.configuration.Config;
import java.util.Locale;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class RubixConfig {
    private ReadMode readMode = ReadMode.READ_THROUGH;
    private String cacheLocation;
    private int bookKeeperServerPort = 8899;
    private int dataTransferServerPort = 8898;

    @NotNull
    public ReadMode getReadMode() {
        return this.readMode;
    }

    @Config(value="hive.cache.read-mode")
    public RubixConfig setReadMode(ReadMode readMode) {
        this.readMode = readMode;
        return this;
    }

    @NotNull
    public String getCacheLocation() {
        return this.cacheLocation;
    }

    @Config(value="hive.cache.location")
    public RubixConfig setCacheLocation(String location) {
        this.cacheLocation = location;
        return this;
    }

    public int getBookKeeperServerPort() {
        return this.bookKeeperServerPort;
    }

    @Config(value="hive.cache.bookkeeper-port")
    public RubixConfig setBookKeeperServerPort(int port) {
        this.bookKeeperServerPort = port;
        return this;
    }

    public int getDataTransferServerPort() {
        return this.dataTransferServerPort;
    }

    @Config(value="hive.cache.data-transfer-port")
    public RubixConfig setDataTransferServerPort(int port) {
        this.dataTransferServerPort = port;
        return this;
    }

    public static enum ReadMode {
        READ_THROUGH(false),
        ASYNC(true);

        private final boolean parallelWarmupEnabled;

        private ReadMode(boolean parallelWarmupEnabled) {
            this.parallelWarmupEnabled = parallelWarmupEnabled;
        }

        public boolean isParallelWarmupEnabled() {
            return this.parallelWarmupEnabled;
        }

        public static ReadMode fromString(String value) {
            switch (Objects.requireNonNull(value, "value is null").toLowerCase(Locale.ENGLISH)) {
                case "async": {
                    return ASYNC;
                }
                case "read-through": {
                    return READ_THROUGH;
                }
            }
            throw new IllegalArgumentException(String.format("Unrecognized value: '%s'", value));
        }
    }
}

