/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rubix;

import com.google.common.base.Preconditions;
import com.qubole.rubix.prestosql.CachingPrestoGoogleHadoopFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoNativeAzureFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoS3FileSystem;
import com.qubole.rubix.prestosql.PrestoClusterManager;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.ClusterType;
import io.prestosql.plugin.hive.ConfigurationInitializer;
import io.prestosql.plugin.hive.rubix.RubixConfig;
import io.prestosql.spi.HostAddress;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class RubixConfigurationInitializer
implements ConfigurationInitializer {
    private static final String RUBIX_S3_FS_CLASS_NAME = CachingPrestoS3FileSystem.class.getName();
    private static final String RUBIX_AZURE_FS_CLASS_NAME = CachingPrestoNativeAzureFileSystem.class.getName();
    private static final String RUBIX_GS_FS_CLASS_NAME = CachingPrestoGoogleHadoopFileSystem.class.getName();
    private final boolean parallelWarmupEnabled;
    private final String cacheLocation;
    private final int bookKeeperServerPort;
    private final int dataTransferServerPort;
    private volatile boolean cacheReady;
    private boolean isMaster;
    private HostAddress masterAddress;
    private String nodeAddress;

    @Inject
    public RubixConfigurationInitializer(RubixConfig config) {
        this.parallelWarmupEnabled = config.getReadMode().isParallelWarmupEnabled();
        this.cacheLocation = config.getCacheLocation();
        this.bookKeeperServerPort = config.getBookKeeperServerPort();
        this.dataTransferServerPort = config.getDataTransferServerPort();
    }

    @Override
    public void initializeConfiguration(Configuration config) {
        if (!this.cacheReady) {
            CacheConfig.setCacheDataEnabled((Configuration)config, (boolean)false);
            return;
        }
        this.updateConfiguration(config);
    }

    public Configuration updateConfiguration(Configuration config) {
        Preconditions.checkState((this.masterAddress != null ? 1 : 0) != 0, (Object)"masterAddress is not set");
        CacheConfig.setCacheDataEnabled((Configuration)config, (boolean)true);
        CacheConfig.setOnMaster((Configuration)config, (boolean)this.isMaster);
        CacheConfig.setCoordinatorHostName((Configuration)config, (String)this.masterAddress.getHostText());
        PrestoClusterManager.setPrestoServerPort((Configuration)config, (int)this.masterAddress.getPort());
        CacheConfig.setCurrentNodeHostName((Configuration)config, (String)this.nodeAddress);
        CacheConfig.setIsParallelWarmupEnabled((Configuration)config, (boolean)this.parallelWarmupEnabled);
        CacheConfig.setCacheDataDirPrefix((Configuration)config, (String)this.cacheLocation);
        CacheConfig.setBookKeeperServerPort((Configuration)config, (int)this.bookKeeperServerPort);
        CacheConfig.setDataTransferServerPort((Configuration)config, (int)this.dataTransferServerPort);
        CacheConfig.setEmbeddedMode((Configuration)config, (boolean)true);
        CacheConfig.setRubixClusterType((Configuration)config, (ClusterType)ClusterType.PRESTOSQL_CLUSTER_MANAGER);
        CacheConfig.enableHeartbeat((Configuration)config, (boolean)false);
        CacheConfig.setClusterNodeRefreshTime((Configuration)config, (int)10);
        CacheConfig.setClusterNodesFetchRetryCount((Configuration)config, (int)Integer.MAX_VALUE);
        CacheConfig.setWorkerNodeInfoExpiryPeriod((Configuration)config, (int)1);
        config.set("fs.s3.impl", RUBIX_S3_FS_CLASS_NAME);
        config.set("fs.s3a.impl", RUBIX_S3_FS_CLASS_NAME);
        config.set("fs.s3n.impl", RUBIX_S3_FS_CLASS_NAME);
        config.set("fs.wasb.impl", RUBIX_AZURE_FS_CLASS_NAME);
        config.set("fs.gs.impl", RUBIX_GS_FS_CLASS_NAME);
        return config;
    }

    public void setMaster(boolean master) {
        this.isMaster = master;
    }

    public void setMasterAddress(HostAddress masterAddress) {
        this.masterAddress = masterAddress;
    }

    public void setCurrentNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public void initializationDone() {
        Preconditions.checkState((this.masterAddress != null ? 1 : 0) != 0, (Object)"masterAddress is not set");
        this.cacheReady = true;
    }
}

