/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rubix;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.BookKeeperServer;
import com.qubole.rubix.bookkeeper.LocalDataTransferServer;
import com.qubole.rubix.core.CachingFileSystem;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import io.airlift.log.Logger;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.rubix.RubixConfigurationInitializer;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.spi.Node;
import io.prestosql.spi.NodeManager;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class RubixInitializer {
    private static final Logger log = Logger.get(RubixInitializer.class);
    private final CatalogName catalogName;
    private final RubixConfigurationInitializer rubixConfigurationInitializer;
    private final HdfsConfigurationInitializer hdfsConfigurationInitializer;

    @Inject
    public RubixInitializer(CatalogName catalogName, RubixConfigurationInitializer rubixConfigurationInitializer, HdfsConfigurationInitializer hdfsConfigurationInitializer) {
        this.catalogName = catalogName;
        this.rubixConfigurationInitializer = rubixConfigurationInitializer;
        this.hdfsConfigurationInitializer = hdfsConfigurationInitializer;
    }

    public void initializeRubix(NodeManager nodeManager) {
        ExecutorService initializerService = Executors.newSingleThreadExecutor();
        ListenableFuture nodeJoinFuture = MoreExecutors.listeningDecorator((ExecutorService)initializerService).submit(() -> {
            while (!nodeManager.getAllNodes().contains(nodeManager.getCurrentNode()) || !nodeManager.getAllNodes().stream().anyMatch(Node::isCoordinator)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return true;
        });
        Futures.transform((ListenableFuture)nodeJoinFuture, nodeJoined -> {
            if (nodeJoined.booleanValue()) {
                Node master = nodeManager.getAllNodes().stream().filter(node -> node.isCoordinator()).findFirst().get();
                boolean isMaster = nodeManager.getCurrentNode().isCoordinator();
                this.rubixConfigurationInitializer.setMaster(isMaster);
                this.rubixConfigurationInitializer.setMasterAddress(master.getHostAndPort());
                this.rubixConfigurationInitializer.setCurrentNodeAddress(nodeManager.getCurrentNode().getHost());
                Configuration configuration = ConfigurationUtils.getInitialConfiguration();
                this.hdfsConfigurationInitializer.initializeConfiguration(configuration);
                this.rubixConfigurationInitializer.updateConfiguration(configuration);
                MetricRegistry metricRegistry = new MetricRegistry();
                BookKeeperServer bookKeeperServer = new BookKeeperServer();
                BookKeeper bookKeeper = bookKeeperServer.startServer(configuration, metricRegistry);
                LocalDataTransferServer.startServer((Configuration)configuration, (MetricRegistry)metricRegistry, (BookKeeper)bookKeeper);
                CachingFileSystem.setLocalBookKeeper((BookKeeperService.Iface)bookKeeper, (String)("catalog=" + this.catalogName));
                log.info("Rubix initialized successfully");
                this.rubixConfigurationInitializer.initializationDone();
            }
            return null;
        }, (Executor)initializerService);
    }
}

