/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Optional;

public class S3SecurityMappingConfig {
    private File configFile;
    private String roleCredentialName;
    private Duration refreshPeriod;
    private String colonReplacement;

    public Optional<File> getConfigFile() {
        return Optional.ofNullable(this.configFile);
    }

    @Config(value="hive.s3.security-mapping.config-file")
    @ConfigDescription(value="JSON configuration file containing security mappings")
    public S3SecurityMappingConfig setConfigFile(File configFile) {
        this.configFile = configFile;
        return this;
    }

    public Optional<String> getRoleCredentialName() {
        return Optional.ofNullable(this.roleCredentialName);
    }

    @Config(value="hive.s3.security-mapping.iam-role-credential-name")
    @ConfigDescription(value="Name of the extra credential used to provide IAM role")
    public S3SecurityMappingConfig setRoleCredentialName(String roleCredentialName) {
        this.roleCredentialName = roleCredentialName;
        return this;
    }

    public Optional<Duration> getRefreshPeriod() {
        return Optional.ofNullable(this.refreshPeriod);
    }

    @Config(value="hive.s3.security-mapping.refresh-period")
    @ConfigDescription(value="How often to refresh the security mapping configuration")
    public S3SecurityMappingConfig setRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
        return this;
    }

    public Optional<String> getColonReplacement() {
        return Optional.ofNullable(this.colonReplacement);
    }

    @Config(value="hive.s3.security-mapping.colon-replacement")
    @ConfigDescription(value="Value used in place of colon for IAM role name in extra credentials")
    public S3SecurityMappingConfig setColonReplacement(String colonReplacement) {
        this.colonReplacement = colonReplacement;
        return this;
    }
}

