/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.s3.S3SecurityMapping;
import io.prestosql.spi.security.ConnectorIdentity;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class S3SecurityMappings {
    private final List<S3SecurityMapping> mappings;

    @JsonCreator
    public S3SecurityMappings(@JsonProperty(value="mappings") List<S3SecurityMapping> mappings) {
        this.mappings = ImmutableList.copyOf((Collection)Objects.requireNonNull(mappings, "mappings is null"));
    }

    public Optional<S3SecurityMapping> getMapping(ConnectorIdentity identity, URI uri) {
        return this.mappings.stream().filter(mapping -> mapping.matches(identity, uri)).findFirst();
    }
}

