/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.security.AccessControlMetadata;
import io.prestosql.plugin.hive.security.AccessControlMetadataFactory;
import io.prestosql.plugin.hive.security.SqlStandardAccessControl;
import io.prestosql.plugin.hive.security.SqlStandardAccessControlMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;

public class SqlStandardSecurityModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ConnectorAccessControl.class).to(SqlStandardAccessControl.class).in(Scopes.SINGLETON);
        binder.bind(AccessControlMetadataFactory.class).to(SqlStandardAccessControlMetadataFactory.class);
    }

    private static final class SqlStandardAccessControlMetadataFactory
    implements AccessControlMetadataFactory {
        @Override
        public AccessControlMetadata create(SemiTransactionalHiveMetastore metastore) {
            return new SqlStandardAccessControlMetadata(metastore);
        }
    }
}

