/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.testing;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.prestosql.plugin.hive.HiveHandleResolver;
import io.prestosql.plugin.hive.InternalHiveConnectorFactory;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingHiveConnectorFactory
implements ConnectorFactory {
    private final HiveMetastore metastore;
    private final Module module;

    public TestingHiveConnectorFactory(HiveMetastore metastore) {
        this(metastore, Modules.EMPTY_MODULE);
    }

    public TestingHiveConnectorFactory(HiveMetastore metastore, Module module) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public String getName() {
        return "hive";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new HiveHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return InternalHiveConnectorFactory.createConnector(catalogName, config, context, this.module, Optional.of(this.metastore));
    }
}

