/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import io.prestosql.plugin.hive.HiveCompressionCodec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.SequenceFile;
import org.apache.orc.OrcConf;

public final class CompressionConfigUtil {
    private CompressionConfigUtil() {
    }

    public static void configureCompression(Configuration config, HiveCompressionCodec compressionCodec) {
        boolean compression = compressionCodec != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compression);
        config.setBoolean("mapred.output.compress", compression);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compression);
        OrcConf.COMPRESS.setString(config, compressionCodec.getOrcCompressionKind().name());
        if (compressionCodec.getCodec().isPresent()) {
            config.set("mapred.output.compression.codec", compressionCodec.getCodec().get().getName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", compressionCodec.getCodec().get().getName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        config.set("parquet.compression", compressionCodec.getParquetCompressionCodec().name());
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }
}

