/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.util.ResumableTask;
import java.util.concurrent.Executor;

public final class ResumableTasks {
    private static final Logger log = Logger.get(ResumableTasks.class);

    private ResumableTasks() {
    }

    public static ListenableFuture<Void> submit(final Executor executor, final ResumableTask task) {
        final SettableFuture completionFuture = SettableFuture.create();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ResumableTask.TaskStatus status;
                try {
                    status = task.process();
                }
                catch (Throwable t) {
                    log.error(t, "ResumableTask completed exceptionally");
                    completionFuture.setException(t);
                    return;
                }
                if (status.isFinished()) {
                    completionFuture.set(null);
                    return;
                }
                status.getContinuationFuture().addListener((Runnable)this, executor);
            }
        });
        return completionFuture;
    }
}

