/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.orc.TypeDescription;

public class ColumnIdMap
implements Map<TypeDescription, Integer> {
    private final IdentityHashMap<TypeDescription, Integer> idMap = new IdentityHashMap();

    @Override
    public int size() {
        return this.idMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.idMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.idMap.containsValue(value);
    }

    @Override
    public Integer get(Object key) {
        return this.idMap.get(key);
    }

    @Override
    public Integer put(TypeDescription key, Integer value) {
        return this.idMap.put(key, value);
    }

    @Override
    public Integer remove(Object key) {
        return this.idMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends TypeDescription, ? extends Integer> map) {
        this.idMap.putAll(map);
    }

    @Override
    public void clear() {
        this.idMap.clear();
    }

    @Override
    public Set<TypeDescription> keySet() {
        return this.idMap.keySet();
    }

    @Override
    public Collection<Integer> values() {
        return this.idMap.values();
    }

    @Override
    public Set<Map.Entry<TypeDescription, Integer>> entrySet() {
        return this.idMap.entrySet();
    }

    public ByteBuffer serialize() {
        StringBuilder buffer = new StringBuilder();
        boolean needComma = false;
        for (TypeDescription key : this.idMap.keySet()) {
            if (needComma) {
                buffer.append(',');
            } else {
                needComma = true;
            }
            buffer.append(key.getId());
            buffer.append(':');
            buffer.append(this.idMap.get(key));
        }
        return ByteBuffer.wrap(buffer.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static ColumnIdMap deserialize(TypeDescription schema, ByteBuffer serial) {
        ColumnIdMap result = new ColumnIdMap();
        String[] parts = StandardCharsets.UTF_8.decode(serial).toString().split(",");
        for (int i = 0; i < parts.length; ++i) {
            String[] subparts = parts[i].split(":");
            result.put(schema.findSubtype(Integer.parseInt(subparts[0])), Integer.parseInt(subparts[1]));
        }
        return result;
    }
}

