/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ColumnIdMap;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

class OrcFileAppender<D>
implements FileAppender<D> {
    private final int batchSize;
    private final TypeDescription orcSchema;
    private final ColumnIdMap columnIds = new ColumnIdMap();
    private final Path path;
    private final Writer writer;
    private final VectorizedRowBatch batch;
    private final OrcValueWriter<D> valueWriter;
    private boolean isClosed = false;
    private final Configuration conf;
    private static final String COLUMN_NUMBERS_ATTRIBUTE = "iceberg.column.ids";

    OrcFileAppender(TypeDescription schema, OutputFile file, Function<TypeDescription, OrcValueWriter<?>> createWriterFunc, Configuration conf, Map<String, byte[]> metadata, int batchSize) {
        this.conf = conf;
        this.orcSchema = schema;
        this.path = new Path(file.location());
        this.batchSize = batchSize;
        this.batch = this.orcSchema.createRowBatch(this.batchSize);
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf);
        options.setSchema(this.orcSchema);
        this.writer = OrcFileAppender.newOrcWriter(file, this.columnIds, options, metadata);
        this.valueWriter = OrcFileAppender.newOrcValueWriter(this.orcSchema, createWriterFunc);
    }

    public void add(D datum) {
        try {
            this.valueWriter.write(datum, this.batch);
            if (this.batch.size == this.batchSize) {
                this.writer.addRowBatch(this.batch);
                this.batch.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem writing to ORC file " + this.path, e);
        }
    }

    public Metrics metrics() {
        try {
            long rows = this.writer.getNumberOfRows();
            ColumnStatistics[] stats = this.writer.getStatistics();
            HashMap<Integer, Long> valueCounts = new HashMap<Integer, Long>();
            HashMap<Integer, Long> nullCounts = new HashMap<Integer, Long>();
            Integer[] icebergIds = new Integer[this.orcSchema.getMaximumId() + 1];
            for (TypeDescription type : this.columnIds.keySet()) {
                icebergIds[type.getId()] = this.columnIds.get(type);
            }
            for (int c = 1; c < stats.length; ++c) {
                if (icebergIds[c] == null) continue;
                valueCounts.put(icebergIds[c], stats[c].getNumberOfValues());
            }
            for (TypeDescription child : this.orcSchema.getChildren()) {
                int childId = child.getId();
                if (icebergIds[childId] == null) continue;
                nullCounts.put(icebergIds[childId], rows - stats[childId].getNumberOfValues());
            }
            return new Metrics(Long.valueOf(rows), null, valueCounts, nullCounts);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get statistics " + this.path, e);
        }
    }

    public long length() {
        Preconditions.checkState((boolean)this.isClosed, (Object)"Cannot return length while appending to an open file.");
        return this.writer.getRawDataSize();
    }

    public List<Long> splitOffsets() {
        Reader reader;
        Preconditions.checkState((boolean)this.isClosed, (Object)"File is not yet closed");
        try {
            reader = OrcFile.createReader((Path)this.path, (OrcFile.ReaderOptions)new OrcFile.ReaderOptions(this.conf));
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot read file " + this.path, new Object[]{e});
        }
        List stripes = reader.getStripes();
        return Collections.unmodifiableList(Lists.transform((List)stripes, StripeInformation::getOffset));
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            try {
                if (this.batch.size > 0) {
                    this.writer.addRowBatch(this.batch);
                    this.batch.reset();
                }
            }
            finally {
                this.writer.close();
                this.isClosed = true;
            }
        }
    }

    private static Writer newOrcWriter(OutputFile file, ColumnIdMap columnIds, OrcFile.WriterOptions options, Map<String, byte[]> metadata) {
        Writer writer;
        Path locPath = new Path(file.location());
        try {
            writer = OrcFile.createWriter((Path)locPath, (OrcFile.WriterOptions)options);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't create file " + locPath, e);
        }
        writer.addUserMetadata(COLUMN_NUMBERS_ATTRIBUTE, columnIds.serialize());
        metadata.forEach((key, value) -> writer.addUserMetadata(key, ByteBuffer.wrap(value)));
        return writer;
    }

    private static <D> OrcValueWriter<D> newOrcValueWriter(TypeDescription schema, Function<TypeDescription, OrcValueWriter<?>> createWriterFunc) {
        return createWriterFunc.apply(schema);
    }
}

