/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;

public class OrcMetrics {
    private OrcMetrics() {
    }

    public static Metrics fromInputFile(InputFile file) {
        Configuration config = file instanceof HadoopInputFile ? ((HadoopInputFile)file).getConf() : new Configuration();
        return OrcMetrics.fromInputFile(file, config);
    }

    public static Metrics fromInputFile(InputFile file, Configuration config) {
        try {
            Reader orcReader = OrcFile.createReader((Path)new Path(file.location()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)config));
            return new Metrics(Long.valueOf(orcReader.getNumberOfRows()), null, null, Collections.emptyMap(), null, null);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to read footer of file: %s", new Object[]{file});
        }
    }
}

