/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientPool<C, E extends Exception>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ClientPool.class);
    private final int poolSize;
    private final Deque<C> clients;
    private final Class<? extends E> reconnectExc;
    private final Object signal = new Object();
    private volatile int currentSize;
    private boolean closed;
    private int runs = 0;

    ClientPool(int poolSize, Class<? extends E> reconnectExc) {
        this.poolSize = poolSize;
        this.reconnectExc = reconnectExc;
        this.clients = new ArrayDeque<C>(poolSize);
        this.currentSize = 0;
        this.closed = false;
    }

    public <R> R run(Action<R, C, E> action) throws E, InterruptedException {
        ++this.runs;
        C client = this.get();
        try {
            R r = action.run(client);
            return r;
        }
        catch (Exception exc) {
            if (this.reconnectExc.isInstance(exc)) {
                try {
                    client = this.reconnect(client);
                }
                catch (Exception ignored) {
                    throw (Exception)this.reconnectExc.cast(exc);
                }
                R r = action.run(client);
                return r;
            }
            throw exc;
        }
        finally {
            this.release(client);
        }
    }

    protected abstract C newClient();

    protected abstract C reconnect(C var1);

    protected abstract void close(C var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        this.closed = true;
        try {
            while (this.currentSize > 0) {
                Object object;
                if (!this.clients.isEmpty()) {
                    object = this;
                    synchronized (object) {
                        if (!this.clients.isEmpty()) {
                            C client = this.clients.removeFirst();
                            this.close(client);
                            --this.currentSize;
                        }
                    }
                }
                if (!this.clients.isEmpty() || this.currentSize <= 0) continue;
                object = this.signal;
                synchronized (object) {
                    this.signal.wait(1000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted while shutting down pool. Some clients may not be closed.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C get() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot get a client from a closed pool");
        while (true) {
            Object object;
            if (!this.clients.isEmpty() || this.currentSize < this.poolSize) {
                object = this;
                synchronized (object) {
                    if (!this.clients.isEmpty()) {
                        return this.clients.removeFirst();
                    }
                    if (this.currentSize < this.poolSize) {
                        ++this.currentSize;
                        return this.newClient();
                    }
                }
            }
            object = this.signal;
            synchronized (object) {
                this.signal.wait(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(C client) {
        Object object = this;
        synchronized (object) {
            this.clients.addFirst(client);
        }
        object = this.signal;
        synchronized (object) {
            this.signal.notify();
        }
    }

    public static interface Action<R, C, E extends Exception> {
        public R run(C var1) throws E;
    }
}

