/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends BaseMetastoreCatalog
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    private final HiveClientPool clients;
    private final Configuration conf;
    private final StackTraceElement[] createStack;
    private boolean closed;

    public HiveCatalog(Configuration conf) {
        this.clients = new HiveClientPool(2, conf);
        this.conf = conf;
        this.createStack = Thread.currentThread().getStackTrace();
        this.closed = false;
    }

    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        Preconditions.checkArgument((identifier.namespace().levels().length == 1 ? 1 : 0) != 0, (String)"Missing database in table identifier: %s", (Object)identifier);
        return super.createTable(identifier, schema, spec, location, properties);
    }

    public Table loadTable(TableIdentifier identifier) {
        Preconditions.checkArgument((identifier.namespace().levels().length >= 1 ? 1 : 0) != 0, (String)"Missing database in table identifier: %s", (Object)identifier);
        return super.loadTable(identifier);
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        Preconditions.checkArgument((identifier.namespace().levels().length == 1 ? 1 : 0) != 0, (String)"Missing database in table identifier: %s", (Object)identifier);
        String database = identifier.namespace().level(0);
        TableOperations ops = this.newTableOps(identifier);
        TableMetadata lastMetadata = purge && ops.current() != null ? ops.current() : null;
        try {
            this.clients.run(client -> {
                client.dropTable(database, identifier.name(), false, false);
                return null;
            });
            if (purge && lastMetadata != null) {
                HiveCatalog.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
            }
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop " + identifier.toString(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropTable", e);
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        Preconditions.checkArgument((from.namespace().levels().length == 1 ? 1 : 0) != 0, (String)"Missing database in table identifier: %s", (Object)from);
        Preconditions.checkArgument((to.namespace().levels().length == 1 ? 1 : 0) != 0, (String)"Missing database in table identifier: %s", (Object)to);
        String toDatabase = to.namespace().level(0);
        String fromDatabase = from.namespace().level(0);
        String fromName = from.name();
        try {
            org.apache.hadoop.hive.metastore.api.Table table = this.clients.run(client -> client.getTable(fromDatabase, fromName));
            table.setDbName(toDatabase);
            table.setTableName(to.name());
            this.clients.run(client -> {
                client.alter_table(fromDatabase, fromName, table);
                return null;
            });
        }
        catch (TException e) {
            throw new RuntimeException("Failed to rename " + from.toString() + " to " + to.toString(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to rename", e);
        }
    }

    public TableOperations newTableOps(TableIdentifier tableIdentifier) {
        String dbName = tableIdentifier.namespace().level(0);
        String tableName = tableIdentifier.name();
        return new HiveTableOperations(this.conf, this.clients, dbName, tableName);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        String warehouseLocation = this.conf.get("hive.metastore.warehouse.dir");
        Preconditions.checkNotNull((Object)warehouseLocation, (Object)"Warehouse location is not set: hive.metastore.warehouse.dir=null");
        return String.format("%s/%s.db/%s", warehouseLocation, tableIdentifier.namespace().levels()[0], tableIdentifier.name());
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.clients.close();
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
        }
    }
}

