/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.CachingOrcDataSource;
import io.prestosql.orc.DiskRange;
import io.prestosql.orc.OrcBlockFactory;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceUtils;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.RowGroup;
import io.prestosql.orc.Stripe;
import io.prestosql.orc.StripeReader;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.MetadataReader;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.PostScript;
import io.prestosql.orc.metadata.StripeInformation;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.StripeStatistics;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.ColumnReaders;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class OrcRecordReader
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcRecordReader.class).instanceSize();
    private final OrcDataSource orcDataSource;
    private final ColumnReader[] columnReaders;
    private final long[] currentBytesPerCell;
    private final long[] maxBytesPerCell;
    private long maxCombinedBytesPerRow;
    private final long totalRowCount;
    private final long splitLength;
    private final long maxBlockBytes;
    private long currentPosition;
    private long currentStripePosition;
    private int currentBatchSize;
    private int nextBatchSize;
    private int maxBatchSize = 1024;
    private final List<StripeInformation> stripes;
    private final StripeReader stripeReader;
    private int currentStripe = -1;
    private AggregatedMemoryContext currentStripeSystemMemoryContext;
    private final long fileRowCount;
    private final List<Long> stripeFilePositions;
    private long filePosition;
    private Iterator<RowGroup> rowGroups = ImmutableList.of().iterator();
    private int currentRowGroup = -1;
    private long currentGroupRowCount;
    private long nextRowInGroup;
    private final Map<String, Slice> userMetadata;
    private final AggregatedMemoryContext systemMemoryUsage;
    private final OrcBlockFactory blockFactory;
    private final Optional<OrcWriteValidation> writeValidation;
    private final Optional<OrcWriteValidation.WriteChecksumBuilder> writeChecksumBuilder;
    private final Optional<OrcWriteValidation.StatisticsValidation> rowGroupStatisticsValidation;
    private final Optional<OrcWriteValidation.StatisticsValidation> stripeStatisticsValidation;
    private final Optional<OrcWriteValidation.StatisticsValidation> fileStatisticsValidation;

    public OrcRecordReader(List<OrcColumn> readColumns, List<Type> readTypes, List<OrcReader.ProjectedLayout> readLayouts, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, Optional<ColumnMetadata<ColumnStatistics>> fileStats, List<Optional<StripeStatistics>> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, ColumnMetadata<OrcType> orcTypes, Optional<OrcDecompressor> decompressor, OptionalInt rowsInRowGroup, DateTimeZone hiveStorageTimeZone, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, OrcReaderOptions options, Map<String, Slice> userMetadata, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, Function<Exception, RuntimeException> exceptionTransform) throws OrcCorruptionException {
        Objects.requireNonNull(readColumns, "readColumns is null");
        Preconditions.checkArgument((readColumns.stream().distinct().count() == (long)readColumns.size() ? 1 : 0) != 0, (Object)"readColumns contains duplicate entries");
        Objects.requireNonNull(readTypes, "readTypes is null");
        Preconditions.checkArgument((readColumns.size() == readTypes.size() ? 1 : 0) != 0, (Object)"readColumns and readTypes must have the same size");
        Objects.requireNonNull(readLayouts, "readLayouts is null");
        Preconditions.checkArgument((readColumns.size() == readLayouts.size() ? 1 : 0) != 0, (Object)"readColumns and readLayouts must have the same size");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(fileStripes, "fileStripes is null");
        Objects.requireNonNull(stripeStats, "stripeStats is null");
        Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        Objects.requireNonNull(orcTypes, "types is null");
        Objects.requireNonNull(decompressor, "decompressor is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(userMetadata, "userMetadata is null");
        Objects.requireNonNull(systemMemoryUsage, "systemMemoryUsage is null");
        Objects.requireNonNull(exceptionTransform, "exceptionTransform is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.writeChecksumBuilder = writeValidation.map(validation -> OrcWriteValidation.WriteChecksumBuilder.createWriteChecksumBuilder(orcTypes, readTypes));
        this.rowGroupStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(orcTypes, readTypes));
        this.stripeStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(orcTypes, readTypes));
        this.fileStatisticsValidation = writeValidation.map(validation -> validation.createWriteStatisticsBuilder(orcTypes, readTypes));
        this.systemMemoryUsage = systemMemoryUsage.newAggregatedMemoryContext();
        this.blockFactory = new OrcBlockFactory(exceptionTransform, options.isNestedLazy());
        Objects.requireNonNull(options, "options is null");
        this.maxBlockBytes = options.getMaxBlockSize().toBytes();
        ArrayList<StripeInfo> stripeInfos = new ArrayList<StripeInfo>();
        for (int i = 0; i < fileStripes.size(); ++i) {
            Optional<StripeStatistics> stats = Optional.empty();
            if (stripeStats.size() == fileStripes.size()) {
                stats = stripeStats.get(i);
            }
            stripeInfos.add(new StripeInfo(fileStripes.get(i), stats));
        }
        stripeInfos.sort(Comparator.comparingLong(info -> info.getStripe().getOffset()));
        long totalRowCount = 0L;
        long fileRowCount = 0L;
        ImmutableList.Builder stripes = ImmutableList.builder();
        ImmutableList.Builder stripeFilePositions = ImmutableList.builder();
        if (!fileStats.isPresent() || predicate.matches(numberOfRows, fileStats.get())) {
            for (StripeInfo info2 : stripeInfos) {
                StripeInformation stripe = info2.getStripe();
                if (OrcRecordReader.splitContainsStripe(splitOffset, splitLength, stripe) && OrcRecordReader.isStripeIncluded(stripe, info2.getStats(), predicate)) {
                    stripes.add((Object)stripe);
                    stripeFilePositions.add((Object)fileRowCount);
                    totalRowCount += (long)stripe.getNumberOfRows();
                }
                fileRowCount += (long)stripe.getNumberOfRows();
            }
        }
        this.totalRowCount = totalRowCount;
        this.stripes = stripes.build();
        this.stripeFilePositions = stripeFilePositions.build();
        this.orcDataSource = orcDataSource = OrcRecordReader.wrapWithCacheIfTinyStripes(orcDataSource, this.stripes, options.getMaxMergeDistance(), options.getTinyStripeThreshold());
        this.splitLength = splitLength;
        this.fileRowCount = stripeInfos.stream().map(StripeInfo::getStripe).mapToLong(StripeInformation::getNumberOfRows).sum();
        this.userMetadata = ImmutableMap.copyOf((Map)Maps.transformValues(userMetadata, Slices::copyOf));
        this.currentStripeSystemMemoryContext = this.systemMemoryUsage.newAggregatedMemoryContext();
        AggregatedMemoryContext streamReadersSystemMemoryContext = this.systemMemoryUsage.newAggregatedMemoryContext();
        this.stripeReader = new StripeReader(orcDataSource, hiveStorageTimeZone.toTimeZone().toZoneId(), decompressor, orcTypes, (Set<OrcColumn>)ImmutableSet.copyOf(readColumns), rowsInRowGroup, predicate, hiveWriterVersion, metadataReader, writeValidation);
        this.columnReaders = this.createColumnReaders(readColumns, readTypes, readLayouts, streamReadersSystemMemoryContext, this.blockFactory);
        this.currentBytesPerCell = new long[this.columnReaders.length];
        this.maxBytesPerCell = new long[this.columnReaders.length];
        this.nextBatchSize = initialBatchSize;
    }

    private static boolean splitContainsStripe(long splitOffset, long splitLength, StripeInformation stripe) {
        long splitEndOffset = splitOffset + splitLength;
        return splitOffset <= stripe.getOffset() && stripe.getOffset() < splitEndOffset;
    }

    private static boolean isStripeIncluded(StripeInformation stripe, Optional<StripeStatistics> stripeStats, OrcPredicate predicate) {
        return stripeStats.map(StripeStatistics::getColumnStatistics).map(columnStats -> predicate.matches(stripe.getNumberOfRows(), (ColumnMetadata<ColumnStatistics>)columnStats)).orElse(true);
    }

    @VisibleForTesting
    static OrcDataSource wrapWithCacheIfTinyStripes(OrcDataSource dataSource, List<StripeInformation> stripes, DataSize maxMergeDistance, DataSize tinyStripeThreshold) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        for (StripeInformation stripe : stripes) {
            if (stripe.getTotalLength() <= tinyStripeThreshold.toBytes()) continue;
            return dataSource;
        }
        return new CachingOrcDataSource(dataSource, LinearProbeRangeFinder.createTinyStripesRangeFinder(stripes, maxMergeDistance, tinyStripeThreshold));
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    public long getFileRowCount() {
        return this.fileRowCount;
    }

    public long getReaderPosition() {
        return this.currentPosition;
    }

    public long getReaderRowCount() {
        return this.totalRowCount;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    public long getMaxCombinedBytesPerRow() {
        return this.maxCombinedBytesPerRow;
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.orcDataSource);
            for (ColumnReader column : this.columnReaders) {
                if (column == null) continue;
                closer.register(column::close);
            }
        }
        if (this.writeChecksumBuilder.isPresent()) {
            OrcWriteValidation.WriteChecksum actualChecksum = this.writeChecksumBuilder.get().build();
            this.validateWrite(validation -> validation.getChecksum().getTotalRowCount() == actualChecksum.getTotalRowCount(), "Invalid row count", new Object[0]);
            List<Long> columnHashes = actualChecksum.getColumnHashes();
            int i = 0;
            while (i < columnHashes.size()) {
                int columnIndex = i++;
                this.validateWrite(validation -> validation.getChecksum().getColumnHashes().get(columnIndex).equals(columnHashes.get(columnIndex)), "Invalid checksum for column %s", columnIndex);
            }
            this.validateWrite(validation -> validation.getChecksum().getStripeHash() == actualChecksum.getStripeHash(), "Invalid stripes checksum", new Object[0]);
        }
        if (this.fileStatisticsValidation.isPresent()) {
            Optional<ColumnMetadata<ColumnStatistics>> columnStatistics = this.fileStatisticsValidation.get().build();
            this.writeValidation.get().validateFileStatistics(this.orcDataSource.getId(), columnStatistics);
        }
    }

    public Page nextPage() throws IOException {
        this.filePosition += (long)this.currentBatchSize;
        this.currentPosition += (long)this.currentBatchSize;
        this.currentBatchSize = 0;
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            this.filePosition = this.fileRowCount;
            this.currentPosition = this.totalRowCount;
            return null;
        }
        this.currentBatchSize = Math.min(this.nextBatchSize, this.maxBatchSize);
        this.nextBatchSize = Math.min(this.currentBatchSize * 2, 1024);
        this.currentBatchSize = Math.toIntExact(Math.min((long)this.currentBatchSize, this.currentGroupRowCount - this.nextRowInGroup));
        for (ColumnReader column : this.columnReaders) {
            if (column == null) continue;
            column.prepareNextRead(this.currentBatchSize);
        }
        this.nextRowInGroup += (long)this.currentBatchSize;
        this.blockFactory.nextPage();
        Arrays.fill(this.currentBytesPerCell, 0L);
        Block[] blocks = new Block[this.columnReaders.length];
        int i = 0;
        while (i < this.columnReaders.length) {
            int columnIndex = i++;
            blocks[columnIndex] = this.blockFactory.createBlock(this.currentBatchSize, this.columnReaders[columnIndex]::readBlock, false);
            LazyBlock.listenForLoads((Block)blocks[columnIndex], block -> this.blockLoaded(columnIndex, (Block)block));
        }
        Page page = new Page(this.currentBatchSize, blocks);
        this.validateWritePageChecksum(page);
        return page;
    }

    private void blockLoaded(int columnIndex, Block block) {
        if (block.getPositionCount() <= 0) {
            return;
        }
        int n = columnIndex;
        this.currentBytesPerCell[n] = this.currentBytesPerCell[n] + block.getSizeInBytes() / (long)this.currentBatchSize;
        if (this.maxBytesPerCell[columnIndex] < this.currentBytesPerCell[columnIndex]) {
            long delta = this.currentBytesPerCell[columnIndex] - this.maxBytesPerCell[columnIndex];
            this.maxCombinedBytesPerRow += delta;
            this.maxBytesPerCell[columnIndex] = this.currentBytesPerCell[columnIndex];
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxBlockBytes / this.maxCombinedBytesPerRow)));
        }
    }

    public Map<String, Slice> getUserMetadata() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.userMetadata, Slices::copyOf));
    }

    private boolean advanceToNextRowGroup() throws IOException {
        this.nextRowInGroup = 0L;
        if (this.currentRowGroup >= 0 && this.rowGroupStatisticsValidation.isPresent()) {
            OrcWriteValidation.StatisticsValidation statisticsValidation = this.rowGroupStatisticsValidation.get();
            long offset = this.stripes.get(this.currentStripe).getOffset();
            this.writeValidation.get().validateRowGroupStatistics(this.orcDataSource.getId(), offset, this.currentRowGroup, statisticsValidation.build().get());
            statisticsValidation.reset();
        }
        while (!this.rowGroups.hasNext() && this.currentStripe < this.stripes.size()) {
            this.advanceToNextStripe();
            this.currentRowGroup = -1;
        }
        if (!this.rowGroups.hasNext()) {
            this.currentGroupRowCount = 0L;
            return false;
        }
        ++this.currentRowGroup;
        RowGroup currentRowGroup = this.rowGroups.next();
        this.currentGroupRowCount = currentRowGroup.getRowCount();
        if (currentRowGroup.getMinAverageRowBytes() > 0L) {
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxBlockBytes / currentRowGroup.getMinAverageRowBytes())));
        }
        this.currentPosition = this.currentStripePosition + currentRowGroup.getRowOffset();
        this.filePosition = this.stripeFilePositions.get(this.currentStripe) + currentRowGroup.getRowOffset();
        InputStreamSources rowGroupStreamSources = currentRowGroup.getStreamSources();
        for (ColumnReader column : this.columnReaders) {
            if (column == null) continue;
            column.startRowGroup(rowGroupStreamSources);
        }
        return true;
    }

    private void advanceToNextStripe() throws IOException {
        this.currentStripeSystemMemoryContext.close();
        this.currentStripeSystemMemoryContext = this.systemMemoryUsage.newAggregatedMemoryContext();
        this.rowGroups = ImmutableList.of().iterator();
        if (this.currentStripe >= 0 && this.stripeStatisticsValidation.isPresent()) {
            OrcWriteValidation.StatisticsValidation statisticsValidation = this.stripeStatisticsValidation.get();
            long offset = this.stripes.get(this.currentStripe).getOffset();
            this.writeValidation.get().validateStripeStatistics(this.orcDataSource.getId(), offset, statisticsValidation.build().get());
            statisticsValidation.reset();
        }
        ++this.currentStripe;
        if (this.currentStripe >= this.stripes.size()) {
            return;
        }
        if (this.currentStripe > 0) {
            this.currentStripePosition += (long)this.stripes.get(this.currentStripe - 1).getNumberOfRows();
        }
        StripeInformation stripeInformation = this.stripes.get(this.currentStripe);
        this.validateWriteStripe(stripeInformation.getNumberOfRows());
        Stripe stripe = this.stripeReader.readStripe(stripeInformation, this.currentStripeSystemMemoryContext);
        if (stripe != null) {
            InputStreamSources dictionaryStreamSources = stripe.getDictionaryStreamSources();
            ColumnMetadata<ColumnEncoding> columnEncodings = stripe.getColumnEncodings();
            ZoneId fileTimeZone = stripe.getFileTimeZone();
            ZoneId storageTimeZone = stripe.getStorageTimeZone();
            for (ColumnReader column : this.columnReaders) {
                if (column == null) continue;
                column.startStripe(fileTimeZone, storageTimeZone, dictionaryStreamSources, columnEncodings);
            }
            this.rowGroups = stripe.getRowGroups().iterator();
        }
    }

    private void validateWrite(Predicate<OrcWriteValidation> test, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (this.writeValidation.isPresent() && !test.test(this.writeValidation.get())) {
            throw new OrcCorruptionException(this.orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }

    private void validateWriteStripe(int rowCount) {
        this.writeChecksumBuilder.ifPresent(builder -> builder.addStripe(rowCount));
    }

    private void validateWritePageChecksum(Page page) {
        if (this.writeChecksumBuilder.isPresent()) {
            page = page.getLoadedPage();
            this.writeChecksumBuilder.get().addPage(page);
            this.rowGroupStatisticsValidation.get().addPage(page);
            this.stripeStatisticsValidation.get().addPage(page);
            this.fileStatisticsValidation.get().addPage(page);
        }
    }

    private ColumnReader[] createColumnReaders(List<OrcColumn> columns, List<Type> readTypes, List<OrcReader.ProjectedLayout> readLayouts, AggregatedMemoryContext systemMemoryContext, OrcBlockFactory blockFactory) throws OrcCorruptionException {
        ColumnReader[] columnReaders = new ColumnReader[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            int columnIndex = i++;
            Type readType = readTypes.get(columnIndex);
            OrcColumn column = columns.get(columnIndex);
            OrcReader.ProjectedLayout projectedLayout = readLayouts.get(columnIndex);
            columnReaders[columnIndex] = ColumnReaders.createColumnReader(readType, column, projectedLayout, systemMemoryContext, blockFactory);
        }
        return columnReaders;
    }

    @VisibleForTesting
    long getStreamReaderRetainedSizeInBytes() {
        long totalRetainedSizeInBytes = 0L;
        for (ColumnReader column : this.columnReaders) {
            if (column == null) continue;
            totalRetainedSizeInBytes += column.getRetainedSizeInBytes();
        }
        return totalRetainedSizeInBytes;
    }

    @VisibleForTesting
    long getCurrentStripeRetainedSizeInBytes() {
        return this.currentStripeSystemMemoryContext.getBytes();
    }

    @VisibleForTesting
    long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.getStreamReaderRetainedSizeInBytes() + this.getCurrentStripeRetainedSizeInBytes();
    }

    @VisibleForTesting
    long getSystemMemoryUsage() {
        return this.systemMemoryUsage.getBytes();
    }

    static class LinearProbeRangeFinder
    implements CachingOrcDataSource.RegionFinder {
        private final List<DiskRange> diskRanges;
        private int index;

        private LinearProbeRangeFinder(List<DiskRange> diskRanges) {
            this.diskRanges = diskRanges;
        }

        @Override
        public DiskRange getRangeFor(long desiredOffset) {
            while (this.index < this.diskRanges.size()) {
                DiskRange range = this.diskRanges.get(this.index);
                if (range.getEnd() > desiredOffset) {
                    Preconditions.checkArgument((range.getOffset() <= desiredOffset ? 1 : 0) != 0);
                    return range;
                }
                ++this.index;
            }
            throw new IllegalArgumentException("Invalid desiredOffset " + desiredOffset);
        }

        public static LinearProbeRangeFinder createTinyStripesRangeFinder(List<StripeInformation> stripes, DataSize maxMergeDistance, DataSize tinyStripeThreshold) {
            if (stripes.isEmpty()) {
                return new LinearProbeRangeFinder((List<DiskRange>)ImmutableList.of());
            }
            List<DiskRange> scratchDiskRanges = stripes.stream().map(stripe -> new DiskRange(stripe.getOffset(), Math.toIntExact(stripe.getTotalLength()))).collect(Collectors.toList());
            List<DiskRange> diskRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(scratchDiskRanges, maxMergeDistance, tinyStripeThreshold);
            return new LinearProbeRangeFinder(diskRanges);
        }
    }

    private static class StripeInfo {
        private final StripeInformation stripe;
        private final Optional<StripeStatistics> stats;

        public StripeInfo(StripeInformation stripe, Optional<StripeStatistics> stats) {
            this.stripe = Objects.requireNonNull(stripe, "stripe is null");
            this.stats = Objects.requireNonNull(stats, "metadata is null");
        }

        public StripeInformation getStripe() {
            return this.stripe;
        }

        public Optional<StripeStatistics> getStats() {
            return this.stats;
        }
    }
}

