/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.MoreObjects;
import io.prestosql.orc.metadata.OrcColumnId;
import io.prestosql.orc.metadata.Stream;
import java.util.Objects;

public final class StreamId {
    private final OrcColumnId columnId;
    private final Stream.StreamKind streamKind;

    public StreamId(Stream stream) {
        Objects.requireNonNull(stream, "stream is null");
        this.columnId = stream.getColumnId();
        this.streamKind = stream.getStreamKind();
    }

    public StreamId(OrcColumnId columnId, Stream.StreamKind streamKind) {
        this.columnId = columnId;
        this.streamKind = streamKind;
    }

    public OrcColumnId getColumnId() {
        return this.columnId;
    }

    public Stream.StreamKind getStreamKind() {
        return this.streamKind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnId, this.streamKind});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamId streamId = (StreamId)o;
        return Objects.equals(this.columnId, streamId.columnId) && this.streamKind == streamId.streamKind;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnId", (Object)this.columnId).add("streamKind", (Object)this.streamKind).toString();
    }
}

