/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.checkpoint;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.orc.checkpoint.ByteStreamCheckpoint;
import io.prestosql.orc.checkpoint.Checkpoints;
import io.prestosql.orc.checkpoint.StreamCheckpoint;
import java.util.List;
import java.util.Objects;

public final class BooleanStreamCheckpoint
implements StreamCheckpoint {
    private final int offset;
    private final ByteStreamCheckpoint byteStreamCheckpoint;

    public BooleanStreamCheckpoint(int offset, ByteStreamCheckpoint byteStreamCheckpoint) {
        this.offset = offset;
        this.byteStreamCheckpoint = Objects.requireNonNull(byteStreamCheckpoint, "byteStreamCheckpoint is null");
    }

    public BooleanStreamCheckpoint(boolean compressed, Checkpoints.ColumnPositionsList positionsList) {
        this.byteStreamCheckpoint = new ByteStreamCheckpoint(compressed, positionsList);
        this.offset = positionsList.nextPosition();
    }

    public int getOffset() {
        return this.offset;
    }

    public ByteStreamCheckpoint getByteStreamCheckpoint() {
        return this.byteStreamCheckpoint;
    }

    public List<Integer> toPositionList(boolean compressed) {
        return ImmutableList.builder().addAll(this.byteStreamCheckpoint.toPositionList(compressed)).add((Object)this.offset).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.offset).add("byteStreamCheckpoint", (Object)this.byteStreamCheckpoint).toString();
    }
}

