/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.orc.metadata.ColumnMetadata;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.orc.metadata.StripeInformation;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class Footer {
    private final long numberOfRows;
    private final OptionalInt rowsInRowGroup;
    private final List<StripeInformation> stripes;
    private final ColumnMetadata<OrcType> types;
    private final Optional<ColumnMetadata<ColumnStatistics>> fileStats;
    private final Map<String, Slice> userMetadata;

    public Footer(long numberOfRows, OptionalInt rowsInRowGroup, List<StripeInformation> stripes, ColumnMetadata<OrcType> types, Optional<ColumnMetadata<ColumnStatistics>> fileStats, Map<String, Slice> userMetadata) {
        this.numberOfRows = numberOfRows;
        rowsInRowGroup.ifPresent(value -> Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"rowsInRowGroup must be at least 1"));
        this.rowsInRowGroup = rowsInRowGroup;
        this.stripes = ImmutableList.copyOf((Collection)Objects.requireNonNull(stripes, "stripes is null"));
        this.types = Objects.requireNonNull(types, "types is null");
        this.fileStats = Objects.requireNonNull(fileStats, "fileStats is null");
        Objects.requireNonNull(userMetadata, "userMetadata is null");
        this.userMetadata = ImmutableMap.copyOf((Map)Maps.transformValues(userMetadata, Slices::copyOf));
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public OptionalInt getRowsInRowGroup() {
        return this.rowsInRowGroup;
    }

    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    public ColumnMetadata<OrcType> getTypes() {
        return this.types;
    }

    public Optional<ColumnMetadata<ColumnStatistics>> getFileStats() {
        return this.fileStats;
    }

    public Map<String, Slice> getUserMetadata() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.userMetadata, Slices::copyOf));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRows", this.numberOfRows).add("rowsInRowGroup", (Object)this.rowsInRowGroup).add("stripes", this.stripes).add("types", this.types).add("columnStatistics", this.fileStats).add("userMetadata", this.userMetadata.keySet()).toString();
    }
}

