/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata;

import com.google.common.base.MoreObjects;
import io.prestosql.orc.metadata.OrcColumnId;
import java.util.Objects;

public class Stream {
    private final OrcColumnId columnId;
    private final StreamKind streamKind;
    private final int length;
    private final boolean useVInts;

    public Stream(OrcColumnId columnId, StreamKind streamKind, int length, boolean useVInts) {
        this.columnId = columnId;
        this.streamKind = Objects.requireNonNull(streamKind, "streamKind is null");
        this.length = length;
        this.useVInts = useVInts;
    }

    public OrcColumnId getColumnId() {
        return this.columnId;
    }

    public StreamKind getStreamKind() {
        return this.streamKind;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUseVInts() {
        return this.useVInts;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", (Object)this.columnId).add("streamKind", (Object)this.streamKind).add("length", this.length).add("useVInts", this.useVInts).toString();
    }

    public static enum StreamKind {
        PRESENT,
        DATA,
        LENGTH,
        DICTIONARY_DATA,
        DICTIONARY_COUNT,
        SECONDARY,
        ROW_INDEX,
        BLOOM_FILTER,
        BLOOM_FILTER_UTF8;

    }
}

