/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata.statistics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.ByteArrays;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.UnsafeSlice;
import io.prestosql.orc.metadata.statistics.StatisticsHasher;
import org.openjdk.jol.info.ClassLayout;

public class BloomFilter
implements StatisticsHasher.Hashable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BloomFilter.class).instanceSize() + ClassLayout.parseClass(BitSet.class).instanceSize();
    private static final long NULL_HASHCODE = 2862933555777941757L;
    private final BitSet bitSet;
    private final int numBits;
    private final int numHashFunctions;

    public BloomFilter(long expectedEntries, double fpp) {
        Preconditions.checkArgument((expectedEntries > 0L ? 1 : 0) != 0, (Object)"expectedEntries should be > 0");
        Preconditions.checkArgument((fpp > 0.0 && fpp < 1.0 ? 1 : 0) != 0, (Object)"False positive probability should be > 0.0 & < 1.0");
        int nb = BloomFilter.optimalNumOfBits(expectedEntries, fpp);
        this.numBits = nb + (64 - nb % 64);
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedEntries, this.numBits);
        this.bitSet = new BitSet(this.numBits);
    }

    public BloomFilter(long[] bits, int numFuncs) {
        this.bitSet = new BitSet(bits);
        this.numBits = (int)this.bitSet.bitSize();
        this.numHashFunctions = numFuncs;
    }

    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    static int optimalNumOfBits(long n, double p) {
        return (int)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.getBitSet());
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putInt(this.getNumBits()).putInt(this.getNumHashFunctions()).putLongs(this.getBitSet());
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && this.numBits == ((BloomFilter)other).numBits && this.numHashFunctions == ((BloomFilter)other).numHashFunctions && this.bitSet.equals(((BloomFilter)other).bitSet);
    }

    public int hashCode() {
        return this.bitSet.hashCode() + this.numHashFunctions * 5;
    }

    public void add(byte[] val) {
        long hash64 = val == null ? 2862933555777941757L : OrcMurmur3.hash64(val);
        this.addHash(hash64);
    }

    private void addHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.numBits;
            this.bitSet.set(pos);
        }
    }

    public void addLong(long val) {
        this.addHash(BloomFilter.getLongHash(val));
    }

    public void addDouble(double val) {
        this.addLong(Double.doubleToLongBits(val));
    }

    public void addFloat(float val) {
        this.addDouble(val);
    }

    public boolean test(byte[] val) {
        long hash64 = val == null ? 2862933555777941757L : OrcMurmur3.hash64(val);
        return this.testHash(hash64);
    }

    public boolean testSlice(Slice val) {
        long hash64 = val == null ? 2862933555777941757L : OrcMurmur3.hash64(val);
        return this.testHash(hash64);
    }

    private boolean testHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.numBits)) continue;
            return false;
        }
        return true;
    }

    public boolean testLong(long val) {
        return this.testHash(BloomFilter.getLongHash(val));
    }

    private static long getLongHash(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >> 24;
        key = key + (key << 3) + (key << 8);
        key ^= key >> 14;
        key = key + (key << 2) + (key << 4);
        key ^= key >> 28;
        key += key << 31;
        return key;
    }

    public boolean testDouble(double val) {
        return this.testLong(Double.doubleToLongBits(val));
    }

    public boolean testFloat(float val) {
        return this.testDouble(val);
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    public long[] getBitSet() {
        return this.bitSet.getData();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("m", this.numBits).add("k", this.numHashFunctions).toString();
    }

    @VisibleForTesting
    public static final class OrcMurmur3 {
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private static final int R1 = 31;
        private static final int R2 = 27;
        private static final int M = 5;
        private static final int N1 = 1390208809;
        private static final int DEFAULT_SEED = 104729;

        private OrcMurmur3() {
        }

        public static long hash64(byte[] data) {
            long k;
            long hash = 104729L;
            int fastLimit = data.length - 8 + 1;
            int current = 0;
            while (current < fastLimit) {
                k = ByteArrays.getLong((byte[])data, (int)current);
                current += 8;
                k *= -8663945395140668459L;
                k = Long.rotateLeft(k, 31);
                hash ^= (k *= 5545529020109919103L);
                hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
            }
            k = 0L;
            switch (data.length - current) {
                case 7: {
                    k ^= ((long)data[current + 6] & 0xFFL) << 48;
                }
                case 6: {
                    k ^= ((long)data[current + 5] & 0xFFL) << 40;
                }
                case 5: {
                    k ^= ((long)data[current + 4] & 0xFFL) << 32;
                }
                case 4: {
                    k ^= ((long)data[current + 3] & 0xFFL) << 24;
                }
                case 3: {
                    k ^= ((long)data[current + 2] & 0xFFL) << 16;
                }
                case 2: {
                    k ^= ((long)data[current + 1] & 0xFFL) << 8;
                }
                case 1: {
                    k ^= (long)data[current] & 0xFFL;
                    k *= -8663945395140668459L;
                    k = Long.rotateLeft(k, 31);
                    hash ^= (k *= 5545529020109919103L);
                }
            }
            hash ^= (long)data.length;
            hash = OrcMurmur3.fmix64(hash);
            return hash;
        }

        public static long hash64(Slice data) {
            long k;
            long hash = 104729L;
            int fastLimit = data.length() - 8 + 1;
            int current = 0;
            while (current < fastLimit) {
                k = UnsafeSlice.getLongUnchecked((Slice)data, (int)current);
                current += 8;
                k *= -8663945395140668459L;
                k = Long.rotateLeft(k, 31);
                hash ^= (k *= 5545529020109919103L);
                hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
            }
            k = 0L;
            switch (data.length() - current) {
                case 7: {
                    k ^= ((long)UnsafeSlice.getByteUnchecked((Slice)data, (int)(current + 6)) & 0xFFL) << 48;
                }
                case 6: {
                    k ^= ((long)UnsafeSlice.getByteUnchecked((Slice)data, (int)(current + 5)) & 0xFFL) << 40;
                }
                case 5: {
                    k ^= ((long)UnsafeSlice.getByteUnchecked((Slice)data, (int)(current + 4)) & 0xFFL) << 32;
                }
                case 4: {
                    k ^= ((long)UnsafeSlice.getByteUnchecked((Slice)data, (int)(current + 3)) & 0xFFL) << 24;
                }
                case 3: {
                    k ^= ((long)UnsafeSlice.getByteUnchecked((Slice)data, (int)(current + 2)) & 0xFFL) << 16;
                }
                case 2: {
                    k ^= ((long)UnsafeSlice.getByteUnchecked((Slice)data, (int)(current + 1)) & 0xFFL) << 8;
                }
                case 1: {
                    k ^= (long)UnsafeSlice.getByteUnchecked((Slice)data, (int)current) & 0xFFL;
                    k *= -8663945395140668459L;
                    k = Long.rotateLeft(k, 31);
                    hash ^= (k *= 5545529020109919103L);
                }
            }
            hash ^= (long)data.length();
            hash = OrcMurmur3.fmix64(hash);
            return hash;
        }

        private static long fmix64(long h) {
            h ^= h >>> 33;
            h *= -49064778989728563L;
            h ^= h >>> 33;
            h *= -4265267296055464877L;
            h ^= h >>> 33;
            return h;
        }
    }

    public static class BitSet {
        private final long[] data;

        public BitSet(long bits) {
            this(new long[(int)Math.ceil((double)bits / 64.0)]);
        }

        public BitSet(long[] data) {
            Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"data length is zero");
            this.data = data;
        }

        public void set(int index) {
            int n = index >>> 6;
            this.data[n] = this.data[n] | 1L << index;
        }

        public boolean get(int index) {
            return (this.data[index >>> 6] & 1L << index) != 0L;
        }

        public long bitSize() {
            return (long)this.data.length * 64L;
        }

        public long[] getData() {
            return this.data;
        }
    }
}

