/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata.statistics;

import com.google.common.base.MoreObjects;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.prestosql.orc.metadata.statistics.RangeStatistics;
import io.prestosql.orc.metadata.statistics.StatisticsHasher;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class StringStatistics
implements RangeStatistics<Slice>,
StatisticsHasher.Hashable {
    public static final long STRING_VALUE_BYTES_OVERHEAD = 5L;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StringStatistics.class).instanceSize();
    @Nullable
    private final Slice minimum;
    @Nullable
    private final Slice maximum;
    private final long sum;

    public StringStatistics(@Nullable Slice minimum, @Nullable Slice maximum, long sum) {
        if (minimum != null && maximum != null && minimum.compareTo(maximum) > 0) {
            throw new IllegalArgumentException(String.format("minimum is not less than or equal to maximum: '%s' [%s], '%s' [%s]", minimum.toStringUtf8(), BaseEncoding.base16().encode(minimum.getBytes()), maximum.toStringUtf8(), BaseEncoding.base16().encode(maximum.getBytes())));
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.sum = sum;
    }

    @Override
    public Slice getMin() {
        return this.minimum;
    }

    @Override
    public Slice getMax() {
        return this.maximum;
    }

    public long getSum() {
        return this.sum;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + (this.minimum == null ? 0L : this.minimum.getRetainedSize()) + (this.maximum == null || this.maximum == this.minimum ? 0L : this.maximum.getRetainedSize());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringStatistics that = (StringStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum) && Objects.equals(this.sum, that.sum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum, this.sum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)(this.minimum == null ? "<null>" : this.minimum.toStringUtf8())).add("max", (Object)(this.maximum == null ? "<null>" : this.maximum.toStringUtf8())).add("sum", this.sum).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putOptionalSlice(this.minimum).putOptionalSlice(this.maximum).putLong(this.sum);
    }
}

