/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcBlockFactory;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.reader.BooleanColumnReader;
import io.prestosql.orc.reader.ByteColumnReader;
import io.prestosql.orc.reader.ColumnReader;
import io.prestosql.orc.reader.DecimalColumnReader;
import io.prestosql.orc.reader.DoubleColumnReader;
import io.prestosql.orc.reader.FloatColumnReader;
import io.prestosql.orc.reader.ListColumnReader;
import io.prestosql.orc.reader.LongColumnReader;
import io.prestosql.orc.reader.MapColumnReader;
import io.prestosql.orc.reader.SliceColumnReader;
import io.prestosql.orc.reader.StructColumnReader;
import io.prestosql.orc.reader.TimestampColumnReader;
import io.prestosql.spi.type.Type;

public final class ColumnReaders {
    private ColumnReaders() {
    }

    public static ColumnReader createColumnReader(Type type, OrcColumn column, OrcReader.ProjectedLayout projectedLayout, AggregatedMemoryContext systemMemoryContext, OrcBlockFactory blockFactory) throws OrcCorruptionException {
        switch (column.getColumnType()) {
            case BOOLEAN: {
                return new BooleanColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BYTE: {
                return new ByteColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case FLOAT: {
                return new FloatColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                return new DoubleColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceColumnReader(type, column, systemMemoryContext);
            }
            case TIMESTAMP: {
                return new TimestampColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case LIST: {
                return new ListColumnReader(type, column, systemMemoryContext, blockFactory);
            }
            case STRUCT: {
                return new StructColumnReader(type, column, projectedLayout, systemMemoryContext, blockFactory);
            }
            case MAP: {
                return new MapColumnReader(type, column, systemMemoryContext, blockFactory);
            }
            case DECIMAL: {
                return new DecimalColumnReader(type, column, systemMemoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)column.getColumnType()));
    }
}

